/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.petstore.extension.PetStoreConnector;

@RunWith(value=Parameterized.class)
public class XmlExtensionLoaderTestCase
extends AbstractMuleTestCase {
    private XmlExtensionModelLoader loader;
    private final boolean validateXml;

    @Parameterized.Parameters(name="Validate XML: {0}")
    public static List<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    public XmlExtensionLoaderTestCase(boolean validateXml) {
        this.validateXml = validateXml;
    }

    @Before
    public void setUp() {
        this.loader = new XmlExtensionModelLoader();
    }

    @Test
    public void testModuleSimple() {
        String modulePath = "modules/module-simple.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-simple"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)13));
        Optional operationModelOptional = extensionModel.getOperationModel("set-payload-concat-params-values");
        MatcherAssert.assertThat((Object)operationModelOptional.isPresent(), (Matcher)Matchers.is((Object)true));
        OperationModel operationModel = (OperationModel)operationModelOptional.get();
        MatcherAssert.assertThat((Object)operationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)((ParameterModel)operationModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((ParameterModel)operationModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"value2"));
        MatcherAssert.assertThat((Object)((ParameterModel)operationModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)operationModel.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        Optional modelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)operationModel.getOutput().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)operationModel.getOutput().getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)operationModel.getErrorModels().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testModuleProperties() {
        String modulePath = "modules/module-properties.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-properties"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
        MatcherAssert.assertThat((Object)configurationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"configParam"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"defaultConfigParam"));
        Optional globalElementComponentModelModelProperty = extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)globalElementComponentModelModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((GlobalElementComponentModelModelProperty)globalElementComponentModelModelProperty.get()).getGlobalElements().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)configurationModel.getOperationModels().size(), (Matcher)Matchers.is((Object)12));
        Optional operationModel = configurationModel.getOperationModel("set-payload-add-param-and-property-values");
        MatcherAssert.assertThat((Object)operationModel.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationModel)operationModel.get()).getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"config-ref"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        Optional modelProperty = ((OperationModel)operationModel.get()).getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testModuleGlobalElement() {
        String modulePath = "modules/module-global-element.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-global-element"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
        MatcherAssert.assertThat((Object)configurationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"username"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"password"));
        Optional globalElementComponentModelModelProperty = extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)globalElementComponentModelModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((GlobalElementComponentModelModelProperty)globalElementComponentModelModelProperty.get()).getGlobalElements().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)configurationModel.getOperationModels().size(), (Matcher)Matchers.is((Object)3));
        Optional operationModel = configurationModel.getOperationModel("do-get-client");
        MatcherAssert.assertThat((Object)operationModel.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationModel)operationModel.get()).getAllParameterModels().size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"config-ref"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)operationModel.get()).getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        Optional modelProperty = ((OperationModel)operationModel.get()).getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testModuleJsonCustomTypes() throws IOException {
        String modulePath = "modules/module-json-custom-types.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-json-custom-types"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)11));
        Optional operationModel = extensionModel.getOperationModel("operation-with-custom-types");
        MatcherAssert.assertThat((Object)operationModel.isPresent(), (Matcher)Matchers.is((Object)true));
        OperationModel operation = (OperationModel)operationModel.get();
        MatcherAssert.assertThat((Object)operation.getAllParameterModels().size(), (Matcher)Matchers.is((Object)4));
        ParameterModel parameterValueModel = (ParameterModel)operation.getAllParameterModels().get(0);
        MatcherAssert.assertThat((Object)parameterValueModel.getName(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)((ParameterModel)operation.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)operation.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        MatcherAssert.assertThat((Object)parameterValueModel.getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)parameterValueModel.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)((ObjectType)parameterValueModel.getType()).getFields().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)operation.getOutput().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)operation.getOutput().getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)((ObjectType)operation.getOutput().getType()).getFields().size(), (Matcher)Matchers.is((Object)3));
        Optional modelProperty = operation.getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testModuleXsdCustomTypes() throws IOException {
        String modulePath = "modules/module-xsd-custom-types.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-xsd-custom-types"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)4));
        Optional operationModel = extensionModel.getOperationModel("operation-with-custom-types");
        MatcherAssert.assertThat((Object)operationModel.isPresent(), (Matcher)Matchers.is((Object)true));
        OperationModel operation = (OperationModel)operationModel.get();
        MatcherAssert.assertThat((Object)operation.getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)((ParameterModel)operation.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)operation.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        ParameterModel firstParameterValueModel = (ParameterModel)operation.getAllParameterModels().get(0);
        MatcherAssert.assertThat((Object)firstParameterValueModel.getName(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)firstParameterValueModel.getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)firstParameterValueModel.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        ObjectType firstInputParameterObjectType = (ObjectType)firstParameterValueModel.getType();
        MatcherAssert.assertThat((Object)firstInputParameterObjectType.getFields().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)firstInputParameterObjectType.getFieldByName("User").isPresent(), (Matcher)Matchers.is((Object)true));
        ParameterModel secondParameterValueModel = (ParameterModel)operation.getAllParameterModels().get(1);
        MatcherAssert.assertThat((Object)secondParameterValueModel.getName(), (Matcher)Matchers.is((Object)"value2"));
        MatcherAssert.assertThat((Object)secondParameterValueModel.getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)secondParameterValueModel.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        ObjectType secondInputParameterObjectType = (ObjectType)secondParameterValueModel.getType();
        MatcherAssert.assertThat((Object)secondInputParameterObjectType.getFields().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)secondInputParameterObjectType.getFieldByName("Root").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)operation.getOutput().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)operation.getOutput().getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        ObjectType outputObjectType = (ObjectType)operation.getOutput().getType();
        MatcherAssert.assertThat((Object)outputObjectType.getFields().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)outputObjectType.getFieldByName("Root0").isPresent(), (Matcher)Matchers.is((Object)true));
        Optional modelProperty = operation.getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testModuleDocumentation() throws IOException {
        String modulePath = "modules/module-documentation.xml";
        List<String> expectedResources = Arrays.asList("resource1.txt", "functions.dwl");
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath, expectedResources);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-documentation"));
        MatcherAssert.assertThat((Object)extensionModel.getDescription(), (Matcher)Matchers.is((Object)"Documentation for the connector"));
        MatcherAssert.assertThat((Object)extensionModel.getResources(), (Matcher)Matchers.is((Matcher)Matchers.containsInAnyOrder((Object[])expectedResources.toArray())));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
        List configurationParameterModels = configurationModel.getAllParameterModels();
        MatcherAssert.assertThat((Object)configurationParameterModels.size(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(0)).getName(), (Matcher)Matchers.is((Object)"aPropertyWithDoc"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(0)).getDescription(), (Matcher)Matchers.is((Object)"Documentation for the property"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(1)).getName(), (Matcher)Matchers.is((Object)"aHiddenPropertyWithDoc"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(1)).getDescription(), (Matcher)Matchers.is((Object)"Documentation for the hidden property"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(1)).getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LayoutModel)((ParameterModel)configurationParameterModels.get(1)).getLayoutModel().get()).isPassword(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(2)).getName(), (Matcher)Matchers.is((Object)"aPropertyDisplayModel"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(2)).getDescription(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(2)).getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)configurationParameterModels.get(2)).getDisplayModel().get()).getDisplayName(), (Matcher)Matchers.is((Object)"A pretty name property"));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)configurationParameterModels.get(2)).getDisplayModel().get()).getSummary(), (Matcher)Matchers.is((Object)"a summary tooltip property"));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)configurationParameterModels.get(2)).getDisplayModel().get()).getExample(), (Matcher)Matchers.is((Object)"SOME_PROPERTY_SAMPLE_DATA"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(3)).getName(), (Matcher)Matchers.is((Object)"aPropertyWithPlacement"));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(3)).getDescription(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)((ParameterModel)configurationParameterModels.get(3)).getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)((LayoutModel)((ParameterModel)configurationParameterModels.get(3)).getLayoutModel().get()).getTabName().get()), (Matcher)Matchers.is((Object)"Not General Property"));
        MatcherAssert.assertThat((Object)((Integer)((LayoutModel)((ParameterModel)configurationParameterModels.get(3)).getLayoutModel().get()).getOrder().get()), (Matcher)Matchers.is((Object)42));
        Optional globalElementComponentModelModelProperty = extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)globalElementComponentModelModelProperty.isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)configurationModel.getOperationModels().size(), (Matcher)Matchers.is((Object)2));
        Optional operationModelOptional = configurationModel.getOperationModel("operation-with-doc");
        this.assertOperationWithDocumentationElementsEverywhere(extensionModel, operationModelOptional);
        Optional anotherOperationModelOptional = configurationModel.getOperationModel("anotherOperationWithDoc");
        this.assertOperationWithDocumentationElementsEverywhere(extensionModel, anotherOperationModelOptional);
    }

    private void assertOperationWithDocumentationElementsEverywhere(ExtensionModel extensionModel, Optional<OperationModel> operationModelOptional) {
        MatcherAssert.assertThat((Object)operationModelOptional.isPresent(), (Matcher)Matchers.is((Object)true));
        OperationModel operationModel = operationModelOptional.get();
        MatcherAssert.assertThat((Object)operationModel.getDescription(), (Matcher)Matchers.is((Object)"Documentation for the operation"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DisplayModel)operationModel.getDisplayModel().get()).getDisplayName(), (Matcher)Matchers.is((Object)"A pretty name for the operation"));
        MatcherAssert.assertThat((Object)((DisplayModel)operationModel.getDisplayModel().get()).getSummary(), (Matcher)Matchers.is((Object)"a summary tooltip operation"));
        MatcherAssert.assertThat((Object)((DisplayModel)operationModel.getDisplayModel().get()).getExample(), (Matcher)Matchers.is((Object)"SOME_OPERATION_SAMPLE_DATA"));
        List allParameterModels = operationModel.getAllParameterModels();
        MatcherAssert.assertThat((Object)allParameterModels.size(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(0)).getName(), (Matcher)Matchers.is((Object)"paramWithDoc"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(0)).getDescription(), (Matcher)Matchers.is((Object)"Documentation for the parameter"));
        MatcherAssert.assertThat((Object)((String)((LayoutModel)((ParameterModel)allParameterModels.get(0)).getLayoutModel().get()).getTabName().get()), (Matcher)Matchers.is((Object)"General"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(1)).getName(), (Matcher)Matchers.is((Object)"hiddenParamWithDoc"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(1)).getDescription(), (Matcher)Matchers.is((Object)"Documentation for the hidden parameter"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(1)).getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LayoutModel)((ParameterModel)allParameterModels.get(1)).getLayoutModel().get()).isPassword(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(2)).getName(), (Matcher)Matchers.is((Object)"paramDisplayModel"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(2)).getDescription(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(2)).getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)allParameterModels.get(2)).getDisplayModel().get()).getDisplayName(), (Matcher)Matchers.is((Object)"A pretty name parameter"));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)allParameterModels.get(2)).getDisplayModel().get()).getSummary(), (Matcher)Matchers.is((Object)"a summary tooltip parameter"));
        MatcherAssert.assertThat((Object)((DisplayModel)((ParameterModel)allParameterModels.get(2)).getDisplayModel().get()).getExample(), (Matcher)Matchers.is((Object)"SOME_PARAMETER_SAMPLE_DATA"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(3)).getName(), (Matcher)Matchers.is((Object)"paramWithPlacement"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(3)).getDescription(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(3)).getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)((LayoutModel)((ParameterModel)allParameterModels.get(3)).getLayoutModel().get()).getTabName().get()), (Matcher)Matchers.is((Object)"Not General Parameter"));
        MatcherAssert.assertThat((Object)((Integer)((LayoutModel)((ParameterModel)allParameterModels.get(3)).getLayoutModel().get()).getOrder().get()), (Matcher)Matchers.is((Object)17));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(4)).getName(), (Matcher)Matchers.is((Object)"config-ref"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(5)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(5)).getDescription(), (Matcher)Matchers.is((Object)"The name of a variable on which the operation's output will be placed"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(6)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        MatcherAssert.assertThat((Object)((ParameterModel)allParameterModels.get(6)).getDescription(), (Matcher)Matchers.is((Object)"An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable"));
        MatcherAssert.assertThat((Object)operationModel.getOutput().getDescription(), (Matcher)Matchers.is((Object)"Documentation for the output"));
        MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getDescription(), (Matcher)Matchers.is((Object)"Documentation for the output attributes"));
        MatcherAssert.assertThat((Object)operationModel.getErrorModels().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)operationModel.getErrorModels(), (Matcher)Matchers.containsInAnyOrder((Object[])new ErrorModel[]{ErrorModelBuilder.newError((String)"CUSTOM_ERROR_HERE", (String)extensionModel.getXmlDslModel().getPrefix().toUpperCase()).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build(), ErrorModelBuilder.newError((String)"ANOTHER_CUSTOM_ERROR_HERE", (String)extensionModel.getXmlDslModel().getPrefix().toUpperCase()).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build()}));
        Optional modelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testModuleWrongBodyContent() {
        String modulePath = "validation/module-wrong-body-content.xml";
        if (this.validateXml) {
            try {
                this.getExtensionModelFrom(modulePath);
                Assert.fail((String)"Should not have reached up to this point, the XML is invalid and the ExtensionModel should not be generated.");
            }
            catch (MuleRuntimeException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"There were '2' error"));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Invalid content was found starting with element"));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"fake-request-config"));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"non-existing-operation"));
            }
        } else {
            ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
            MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-wrong-body-content"));
            MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
            ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
            MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
            MatcherAssert.assertThat((Object)configurationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)3));
            Optional globalElementComponentModelModelProperty = extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class);
            MatcherAssert.assertThat((Object)globalElementComponentModelModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((GlobalElementComponentModelModelProperty)globalElementComponentModelModelProperty.get()).getGlobalElements().size(), (Matcher)Matchers.is((Object)1));
            Optional operationModelOptional = configurationModel.getOperationModel("operation-with-non-valid-body");
            MatcherAssert.assertThat((Object)operationModelOptional.isPresent(), (Matcher)Matchers.is((Object)true));
            OperationModel operationModel = (OperationModel)operationModelOptional.get();
            MatcherAssert.assertThat((Object)operationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)2));
            Optional modelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class);
            MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)1L));
            MatcherAssert.assertThat((Object)operationModel.getOutput().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JAVA));
            MatcherAssert.assertThat((Object)operationModel.getOutput().getType(), (Matcher)Matchers.instanceOf(VoidType.class));
            MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getType().getMetadataFormat(), (Matcher)Matchers.is((Object)MetadataFormat.JAVA));
            MatcherAssert.assertThat((Object)operationModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(VoidType.class));
            MatcherAssert.assertThat((Object)operationModel.getErrorModels().size(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testModuleCallingOperationsWithinModule() {
        String modulePath = "modules/module-calling-operations-within-module.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-calling-operations-within-module"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)12));
    }

    @Test
    @Issue(value="MULE-19483")
    public void moduleCallingOperationsWithinModuleNoTnsSchemaLocation() {
        String modulePath = "modules/module-calling-operations-within-module-no-tns-schema-location.xml";
        if (this.validateXml) {
            try {
                this.getExtensionModelFrom(modulePath);
                Assert.fail((String)"Should not have reached up to this point, the XML is invalid and the ExtensionModel should not be generated.");
            }
            catch (MuleRuntimeException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Invalid content was found starting with element"));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"internal-set-payload-hardcoded-value"));
            }
        } else {
            ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
            MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-calling-operations-within-module"));
            MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)12));
        }
    }

    @Test
    public void testModuleResources() {
        String modulePath = "modules/module-resources.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-resources"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    @Issue(value="W-14943177")
    @Description(value="UX test to ensure parameterized stereotypes properly tells which config can be fed from the tools/UI")
    public void testModuleStereotypes() {
        String modulePath = "modules/module-stereotypes.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-stereotypes"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
        MatcherAssert.assertThat((Object)configurationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        StereotypeModel ironManStereotype = StereotypeModelBuilder.newStereotype((String)"ironMan", (String)"Marvel").withParent(MuleStereotypes.CONFIG).build();
        StereotypeModel heisenbergStereotype = StereotypeModelBuilder.newStereotype((String)"config", (String)"Heisenberg").withParent(MuleStereotypes.CONFIG).build();
        this.assertParameterWithStereotypes((ParameterModel)configurationModel.getAllParameterModels().get(0), "stereotypableIronManConfig", ironManStereotype);
        this.assertParameterWithStereotypes((ParameterModel)configurationModel.getAllParameterModels().get(1), "stereotypableMultipleConfig", heisenbergStereotype, ironManStereotype);
        this.assertParameterWithStereotypes((ParameterModel)configurationModel.getAllParameterModels().get(2), "stereotypableWeirdConfig", ironManStereotype);
        MatcherAssert.assertThat((Object)configurationModel.getConnectionProviders().size(), (Matcher)Matchers.is((Object)1));
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)configurationModel.getConnectionProviders().get(0);
        MatcherAssert.assertThat((Object)connectionProviderModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)2));
        this.assertParameterWithStereotypes((ParameterModel)connectionProviderModel.getAllParameterModels().get(0), "stereotypableIronManConfigInConnection", ironManStereotype);
        this.assertParameterWithStereotypes((ParameterModel)connectionProviderModel.getAllParameterModels().get(1), "stereotypableWeirdConfigInConnection", heisenbergStereotype);
        Optional globalElementComponentModelModelProperty = extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)globalElementComponentModelModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((GlobalElementComponentModelModelProperty)globalElementComponentModelModelProperty.get()).getGlobalElements().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)configurationModel.getOperationModels().size(), (Matcher)Matchers.is((Object)2));
        Optional doSomethingOp = configurationModel.getOperationModel("do-something");
        MatcherAssert.assertThat((Object)doSomethingOp.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationModel)doSomethingOp.get()).getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"aData"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"config-ref"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        Optional modelProperty = ((OperationModel)doSomethingOp.get()).getModelProperty(OperationComponentModelModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationComponentModelModelProperty)modelProperty.get()).getBodyComponentModel().directChildrenStream().count(), (Matcher)Matchers.is((Object)2L));
        Optional callFlowOp = configurationModel.getOperationModel("call-flow");
        MatcherAssert.assertThat((Object)callFlowOp.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationModel)callFlowOp.get()).getAllParameterModels().size(), (Matcher)Matchers.is((Object)5));
        ParameterModel referenceParameter = (ParameterModel)((OperationModel)callFlowOp.get()).getAllParameterModels().get(0);
        this.assertParameterWithStereotypes(referenceParameter, "reference", MuleStereotypes.FLOW, MuleStereotypes.SUB_FLOW);
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"config-ref"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)((ParameterModel)((OperationModel)doSomethingOp.get()).getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
    }

    private void assertParameterWithStereotypes(ParameterModel parameterModel, String propertyName, StereotypeModel ... stereotypeModel) {
        MatcherAssert.assertThat((Object)parameterModel.getName(), (Matcher)Matchers.is((Object)propertyName));
        MatcherAssert.assertThat((Object)parameterModel.getAllowedStereotypes(), (Matcher)Matchers.containsInAnyOrder((Object[])stereotypeModel));
    }

    @Test
    public void testModuleTestConnection() {
        String modulePath = "modules/module-test-connection.xml";
        this.assertTestConnectionModuleOn(modulePath);
    }

    @Test
    public void testModuleTestConnectionMultipleConfigFirst() {
        String modulePath = "modules/module-test-connection-multiple-configs-first.xml";
        this.assertTestConnectionModuleOn(modulePath);
    }

    @Test
    public void testModuleTestConnectionMultipleConfigSecond() {
        String modulePath = "modules/module-test-connection-multiple-configs-second.xml";
        this.assertTestConnectionModuleOn(modulePath);
    }

    private void assertTestConnectionModuleOn(String modulePath) {
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-test-connection"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)1));
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((Object)configurationModel.getName(), (Matcher)Matchers.is((Object)"config"));
        MatcherAssert.assertThat((Object)configurationModel.getAllParameterModels().size(), (Matcher)Matchers.is((Object)4));
        Optional connectionProviderModel = configurationModel.getConnectionProviderModel("connection");
        MatcherAssert.assertThat((Object)connectionProviderModel.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConnectionProviderModel)connectionProviderModel.get()).supportsConnectivityTesting(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="W-12003688")
    public void dontSetDefaultValueToBooleanParams() throws Exception {
        final AtomicReference contextRef = new AtomicReference();
        this.loader = new XmlExtensionModelLoader(){

            protected ExtensionModel doCreate(ExtensionLoadingContext context) {
                contextRef.set(context);
                return super.doCreate(context);
            }
        };
        this.getExtensionModelFrom("modules/module-test-connection.xml");
        MatcherAssert.assertThat((Object)((ExtensionLoadingContext)contextRef.get()).getParameter("EXTENSION_LOADER_DONT_SET_DEFAULT_VALUE_TO_BOOLEAN_PARAMS"), (Matcher)Matchers.is(Optional.of(true)));
    }

    @Test
    @Issue(value="W-12377294")
    public void testModuleCustomErrorInFlowRef() {
        String modulePath = "modules/module-custom-error-in-flow-ref.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        MatcherAssert.assertThat((Object)extensionModel.getName(), (Matcher)Matchers.is((Object)"module-custom-error-in-flow-ref"));
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)extensionModel.getErrorModels().size(), (Matcher)Matchers.is((Object)1));
        ErrorModel errorModel = (ErrorModel)extensionModel.getErrorModels().stream().findFirst().get();
        MatcherAssert.assertThat((Object)errorModel.getNamespace(), (Matcher)Matchers.is((Object)"RAISE-ERROR-IN-FLOW-REF"));
        MatcherAssert.assertThat((Object)errorModel.getType(), (Matcher)Matchers.is((Object)"CUSTOM_ERROR"));
    }

    @Test
    @Issue(value="W-12244913")
    public void connectionProvider() {
        String modulePath = "modules/module-test-connection.xml";
        ExtensionModel extensionModel = this.getExtensionModelFrom(modulePath);
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        MatcherAssert.assertThat((String)"ConfigurationFactoryModelProperty not present", (Object)configurationModel.getModelProperty(ConfigurationFactoryModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)true));
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)configurationModel.getConnectionProviders().get(0);
        MatcherAssert.assertThat((String)"ConnectionProviderFactoryModelProperty not present", (Object)connectionProviderModel.getModelProperty(ConnectionProviderFactoryModelProperty.class).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    private ExtensionModel getExtensionModelFrom(String modulePath) {
        return this.getExtensionModelFrom(modulePath, Collections.emptyList());
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, List<String> expectedResources) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", modulePath);
        parameters.put("validate-xml", this.validateXml);
        if (!expectedResources.isEmpty()) {
            parameters.put("resources-paths", expectedResources);
        }
        ExtensionModel extensionModel = this.loader.loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(this.getDependencyExtensions()), parameters);
        this.assertNoReconnectionIsAdded(extensionModel);
        return extensionModel;
    }

    private void assertNoReconnectionIsAdded(ExtensionModel extensionModel) {
        new ExtensionWalker(){

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                model.getType().getAnnotation(TypeIdAnnotation.class).ifPresent(typeIdAnnotation -> {
                    if ("Reconnection".equals(typeIdAnnotation.getValue())) {
                        Assert.fail((String)"Reconnection element is not allowed in Smart Connectors");
                    }
                });
            }
        }.walk(extensionModel);
    }

    private Set<ExtensionModel> getDependencyExtensions() {
        ExtensionModel petstore = this.loadExtension(PetStoreConnector.class, Collections.emptySet());
        ExtensionModel marvel = this.loadExtension(MarvelExtension.class, Collections.emptySet());
        ExtensionModel ce = MuleExtensionModelProvider.getExtensionModel();
        return Set.of(petstore, marvel, ce);
    }

    private ExtensionModel loadExtension(Class extension, Set<ExtensionModel> deps) {
        DefaultJavaExtensionModelLoader loader = new DefaultJavaExtensionModelLoader();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", extension.getName());
        ctx.put("version", "1.0.0-SNAPSHOT");
        ctx.put("COMPILATION_MODE", true);
        return loader.loadExtensionModel(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(deps), ctx);
    }
}

