/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.test.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PetStoreConnector;

@RunWith(value=Parameterized.class)
public class ModuleSchemaGeneratorTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final String EXPECTED_FILES_DIR = "modules/schema/";
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionSchemas.updateExpectedFilesOnError");
    private static final ExtensionModel PET_STORE_EXTENSION_MODEL = MuleExtensionUtils.loadExtension(PetStoreConnector.class);
    private final ExtensionSchemaGenerator extensionSchemaFactory = ServiceLoader.load(ExtensionSchemaGenerator.class).iterator().next();
    @Parameterized.Parameter(value=1)
    public String extensionModulePath;

    @Parameterized.Parameters(name="{index}: Validating xsd for {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new XmlExtensionModelLoader(), "module-namespace-custom", "module-namespace-custom.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-param-default-types", "module-param-default-types.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-param-custom-types", "module-param-custom-types.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-param-role", "module-param-role.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-param-types", "module-param-types.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-properties-default-types", "module-properties-default-types.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-properties-types", "module-properties-types.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-single-op-with-property", "module-single-op-with-property.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-single-operation", "module-single-operation.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-single-operation-camelized", "module-single-operation-camelized.xsd", null, Collections.emptyList()}, {new XmlExtensionModelLoader(), "module-tls-config", "module-tls-config.xsd", null, Collections.emptyList()});
    }

    public void createDslResolvingContext() throws IOException {
        this.dslResolvingContext = DslResolvingContext.getDefault(ModuleSchemaGeneratorTestCase.getDependencies());
    }

    private static Set<ExtensionModel> getDependencies() {
        HashSet<ExtensionModel> dependencies = new HashSet<ExtensionModel>();
        dependencies.add(MuleExtensionModelProvider.getExtensionModel());
        dependencies.add(PET_STORE_EXTENSION_MODEL);
        return dependencies;
    }

    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    protected String getExpectedFilesDir() {
        return EXPECTED_FILES_DIR;
    }

    protected String doGenerate(ExtensionModel extensionUnderTest) {
        return this.extensionSchemaFactory.generate(extensionUnderTest, DslResolvingContext.getDefault(Collections.emptySet()));
    }

    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        ExtensionsTestUtils.compareXML((String)expectedContent, (String)actualContent);
    }

    protected ExtensionModel doLoadExtension() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", EXPECTED_FILES_DIR + this.extensionModulePath + ".xml");
        parameters.put("COMPILATION_MODE", true);
        return new XmlExtensionModelLoader().loadExtensionModel(contextClassLoader, DslResolvingContext.getDefault(ModuleSchemaGeneratorTestCase.getDependencies()), parameters);
    }
}

