/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;

@Feature(value="SDK")
@Story(value="Expressions on config-ref parameters")
public class ExpressionsOnConfigRefTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @ClassRule
    public static SystemProperty enableDynamicConfigRef = new SystemProperty("mule.experimental.enableDynamicConfigRef", "true");

    @Override
    protected String getModulePath() {
        return "modules/module-properties.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-using-expressions-on-config-ref.xml";
    }

    @Test
    @Description(value="When using a regular static reference it works as always")
    public void setPayloadWithReference() throws Exception {
        CoreEvent response = this.runFlow("setPayloadWithReference");
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"some config-value-parameter"));
    }

    @Test
    @Description(value="When using an expression involving variables from the event, it resolves the right configuration")
    public void setPayloadWithExpression() throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("setPayloadWithExpression").withVariable("configName", (Object)"some-other")).run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"some other config-value-parameter"));
    }

    @Test
    @Description(value="When using an expression resolving to a global element that is not a config it fails (in runtime) with a proper error message")
    public void setPayloadWithExpressionResolvingToNonConfigFails() throws Exception {
        String expectedMessage = "Error resolving configuration for component 'setPayloadWithExpressionResolvingToNonConfig'";
        String expectedCauseMessage = "There is no registered configurationProvider under name 'some-non-config'";
        this.flowRunner("setPayloadWithExpressionResolvingToNonConfig").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage), ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((String)expectedCauseMessage))}));
    }

    @Test
    @Description(value="When using an expression resolving to a global element that is a config of an incompatible type it fails (in runtime) with a proper error message")
    public void setPayloadWithExpressionResolvingToIncompatibleConfigFails() throws Exception {
        String expectedMessage = "Root component 'setPayloadWithExpressionResolvingToIncompatibleConfig' defines an usage of operation 'set-payload-config-param-value' which points to configuration 'some-incompatible-config'. The selected config does not support that operation.";
        this.flowRunner("setPayloadWithExpressionResolvingToIncompatibleConfig").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage)}));
    }

    @Test
    @Description(value="When using an expression resolving to an empty string it fails (in runtime) with a proper error message")
    public void setPayloadWithExpressionResolvingToEmptyStringFails() throws Exception {
        String expectedMessage = "cannot get configuration from a blank provider name";
        this.flowRunner("setPayloadWithExpressionResolvingToEmptyString").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage)}));
    }

    public static class SomeTestProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }
    }
}

