/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;

public class ModuleJsonCustomTypeTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    private static final Map<String, Object> EXPECTED_TYPE_1 = ImmutableMap.of((Object)"street_type", (Object)"Avenue", (Object)"street_name", (Object)"calle 7");
    private static final Map<String, Object> EXPECTED_TYPE_2 = ImmutableMap.of((Object)"firstName", (Object)"Dardo", (Object)"lastName", (Object)"Rocha", (Object)"age", (Object)83);

    @Override
    protected String getModulePath() {
        return "modules/module-json-custom-types.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-using-module-json-custom-types.xml";
    }

    @Test
    public void testSendingJsonType1FromMap() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("testIsJsonType1FromPayloadFlow").withPayload(EXPECTED_TYPE_1)).run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingJsonType1FromExpression() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testIsJsonType1FromExpressionFlow").run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingJsonType1ContentFromMap() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("testIsJsonType1ContentFromPayloadFlow").withPayload(EXPECTED_TYPE_1)).run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingJsonType1ContentFromExpression() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testIsJsonType1ContentFromExpressionFlow").run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingJsonType2FromMap() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("testIsJsonType2FromPayloadFlow").withPayload(EXPECTED_TYPE_2)).run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingJsonType2FromExpression() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testIsJsonType2FromExpressionFlow").run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testHardcodedType1Flow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testHardcodedType1Flow").run();
        this.assertIsJsonType1(muleEvent);
    }

    @Test
    public void testHardcodedType1AndExtractFieldsInVarsFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testHardcodedType1AndExtractFieldsInVarsFlow").run();
        for (Map.Entry<String, Object> entry : EXPECTED_TYPE_1.entrySet()) {
            MatcherAssert.assertThat((Object)((TypedValue)muleEvent.getVariables().get("extracted-" + entry.getKey())).getValue(), (Matcher)Is.is((Object)entry.getValue()));
        }
    }

    @Test
    public void testCopyJsonType1FromExpressionFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testCopyJsonType1FromExpressionFlow").run();
        this.assertIsJsonType1(muleEvent);
    }

    @Test
    public void testExtractingJsonResponseAndFeedingSimpleType() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testExtractingJsonResponseAndFeedingSimpleType").run();
        Map variables = muleEvent.getVariables();
        MatcherAssert.assertThat((Object)((TypedValue)variables.get("checkingNotAvenue")).getValue(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((TypedValue)variables.get("checkingFromExpression")).getValue(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedValue)variables.get("checkingFromHardcodedType1")).getValue(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedValue)variables.get("checkingFromHardcodedType1WithVariables")).getValue(), (Matcher)Is.is((Object)true));
    }

    private void assertIsJsonType1(CoreEvent muleEvent) {
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        for (Map.Entry<String, Object> entry : EXPECTED_TYPE_1.entrySet()) {
            MatcherAssert.assertThat((Object)((Map)muleEvent.getMessage().getPayload().getValue()), (Matcher)Matchers.hasEntry((Object)entry.getKey(), (Object)entry.getValue()));
        }
    }

    @Test
    public void testJoinStringArray() throws Exception {
        CoreEvent event = this.flowRunner("testJoinStringArray").run();
        String content = (String)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.equalTo((Object)"1-2_a-b"));
    }

    @Test
    public void testJoinInlineStringArray() throws Exception {
        CoreEvent event = this.flowRunner("testJoinInlineStringArray").run();
        String content = (String)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.equalTo((Object)"1-2_a-b"));
    }

    @Test
    public void testOperationWithLiteralParameter() throws Exception {
        CoreEvent event = this.flowRunner("testOperationWithLiteralParameter").run();
        String content = (String)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.equalTo((Object)"Test"));
    }

    private void assertIsExpectedType(CoreEvent muleEvent) {
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)true));
    }
}

