/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;

public class ModuleXsdCustomTypeTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    private static final ImmutableMap<String, Object> USER_DATA = ImmutableMap.builder().put((Object)"name", (Object)"somename").put((Object)"kind", (Object)"somekind").put((Object)"weight", (Object)100).put((Object)"email", (Object)"somename@domain.com").put((Object)"userId", (Object)"somename-id").build();
    private static final String USER = "User";
    private static final Map<String, Object> EXPECTED_XSDTYPE_1 = ImmutableMap.of((Object)"User", USER_DATA);

    @Override
    protected String getModulePath() {
        return "modules/module-xsd-custom-types.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-using-module-xsd-custom-types.xml";
    }

    @Test
    public void testSendingXsdType1FromMap() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("testIsXsdType1FromPayloadFlow").withPayload(EXPECTED_XSDTYPE_1)).run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testSendingXsdType1FromExpression() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testIsXsdType1FromExpressionFlow").run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testIsXsdType1WithNamespaceFromExpression() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testIsXsdType1WithNamespaceFromExpressionFlow").run();
        this.assertIsExpectedType(muleEvent);
    }

    @Test
    public void testHardcodedXsdType1Flow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testHardcodedXsdType1Flow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        for (Map.Entry<String, Object> entry : EXPECTED_XSDTYPE_1.entrySet()) {
            MatcherAssert.assertThat((Object)((Map)muleEvent.getMessage().getPayload().getValue()), (Matcher)Matchers.hasEntry((Object)entry.getKey(), (Object)entry.getValue()));
        }
    }

    @Test
    public void testHardcodedXsdType1AndExtractFieldsInVarsFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testHardcodedXsdType1AndExtractFieldsInVarsFlow").run();
        for (Map.Entry entry : USER_DATA.entrySet()) {
            MatcherAssert.assertThat((Object)muleEvent.getVariables().containsKey("extracted-user-" + (String)entry.getKey()), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)((TypedValue)muleEvent.getVariables().get("extracted-user-" + (String)entry.getKey())).getValue(), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testCopyXsdType1WithNamespaceFromExpressionFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testCopyXsdType1WithNamespaceFromExpressionFlow").run();
        this.assertIsXmlType1(muleEvent);
    }

    private void assertIsExpectedType(CoreEvent muleEvent) {
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)true));
    }

    private void assertIsXmlType1(CoreEvent muleEvent) {
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map actualUserMap = (Map)muleEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)actualUserMap.containsKey(USER), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(actualUserMap.get(USER), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map userDataEvent = (Map)actualUserMap.get(USER);
        for (Map.Entry entry : USER_DATA.entrySet()) {
            MatcherAssert.assertThat((Object)userDataEvent, (Matcher)Matchers.hasEntry((Object)((String)entry.getKey()), entry.getValue()));
        }
    }
}

