/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.factories;

import io.qameta.allure.Feature;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@Feature(value="Xml SDK")
public class XmlSdkConnectionProviderWrapperTestCase
extends AbstractMuleContextTestCase {
    private ExtensionModel extensionModel;
    private TestConnectionProvider targetInstance;
    private ObjectType complexType;
    private ConnectionProviderFactory connectionProviderFactory;
    private ConnectionProviderModel connectionProviderModel;

    @Before
    public void before() {
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix("test").build();
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        ObjectTypeBuilder complexTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation("org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderWrapperTestCase.TestConnectionProvider", true, false, true, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        complexTypeBuilder.addField().key("someProperty").value((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        this.complexType = complexTypeBuilder.build();
        this.targetInstance = new TestConnectionProvider();
        this.connectionProviderFactory = (ConnectionProviderFactory)Mockito.mock(ConnectionProviderFactory.class);
        Mockito.when((Object)this.connectionProviderFactory.newInstance()).thenReturn((Object)this.targetInstance);
        ParameterModel somePropertyParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)somePropertyParamModel.getName()).thenReturn((Object)"someProperty");
        ParameterModel objectParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)objectParamModel.getName()).thenReturn((Object)"object");
        Mockito.when((Object)objectParamModel.getType()).thenReturn((Object)this.complexType);
        this.connectionProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        Mockito.when((Object)this.connectionProviderModel.getModelProperty(ConnectionProviderFactoryModelProperty.class)).thenReturn(Optional.of(new ConnectionProviderFactoryModelProperty(this.connectionProviderFactory)));
        ParameterGroupModel paramGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupModel.getParameterModels()).thenReturn(Arrays.asList(somePropertyParamModel, objectParamModel));
        Mockito.when((Object)paramGroupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.connectionProviderModel.getParameterGroupModels()).thenReturn(Arrays.asList(paramGroupModel));
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Arrays.asList(somePropertyParamModel, objectParamModel));
    }

    @Test
    public void providerWithSimpleProperty() throws InitialisationException {
        ComponentAst innerConnectionProviderComponent = this.connectionProviderWithPropertyValue("someProperty");
        Mockito.when((Object)innerConnectionProviderComponent.getModel(ConnectionProviderModel.class)).thenReturn(Optional.of(this.connectionProviderModel));
        Mockito.when((Object)innerConnectionProviderComponent.getExtensionModel()).thenReturn((Object)this.extensionModel);
        TestConnectionProviderWrapper connectionProvider = new TestConnectionProviderWrapper(innerConnectionProviderComponent, p -> Optional.of("someProperty"));
        connectionProvider.setSomeProperty("myValue");
        LifecycleUtils.initialiseIfNeeded((Object)((Object)connectionProvider), (boolean)true, (MuleContext)muleContext);
        ((ConnectionProviderFactory)Mockito.verify((Object)this.connectionProviderFactory)).newInstance();
        MatcherAssert.assertThat((Object)this.targetInstance.getSomeProperty(), (Matcher)CoreMatchers.is((Object)"myValue"));
    }

    @Test
    public void providerWithComplexProperty() throws InitialisationException {
        ComponentAst innerConnectionProviderComponent = this.connectionProviderWithComplexParamWithPropertyValue("someProperty");
        Mockito.when((Object)innerConnectionProviderComponent.getModel(ConnectionProviderModel.class)).thenReturn(Optional.of(this.connectionProviderModel));
        Mockito.when((Object)innerConnectionProviderComponent.getExtensionModel()).thenReturn((Object)this.extensionModel);
        TestConnectionProviderWrapper connectionProvider = new TestConnectionProviderWrapper(innerConnectionProviderComponent, p -> Optional.of("someProperty"));
        connectionProvider.setSomeProperty("myValue");
        LifecycleUtils.initialiseIfNeeded((Object)((Object)connectionProvider), (boolean)true, (MuleContext)muleContext);
        ((ConnectionProviderFactory)Mockito.verify((Object)this.connectionProviderFactory)).newInstance();
        TestConnectionProvider targetNestedObject = (TestConnectionProvider)this.targetInstance.getObject();
        MatcherAssert.assertThat((Object)targetNestedObject.getSomeProperty(), (Matcher)CoreMatchers.is((Object)"myValue"));
    }

    private ComponentAst connectionProviderWithPropertyValue(String propertyName) {
        ParameterModel somePropertyParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)somePropertyParameterModel.getName()).thenReturn((Object)propertyName);
        Mockito.when((Object)somePropertyParameterModel.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        ComponentParameterAst propertyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)propertyParam.getRawValue()).thenReturn((Object)("#[vars." + propertyName + "]"));
        Mockito.when((Object)propertyParam.getModel()).thenReturn((Object)somePropertyParameterModel);
        ComponentAst innerConnectionProviderComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponent.getParameters()).thenReturn(Collections.singleton(propertyParam));
        Mockito.when((Object)innerConnectionProviderComponent.recursiveStream()).thenReturn(Stream.of(innerConnectionProviderComponent));
        return innerConnectionProviderComponent;
    }

    private ComponentAst connectionProviderWithComplexParamWithPropertyValue(String propertyName) {
        ParameterModel somePropertyParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)somePropertyParameterModel.getName()).thenReturn((Object)propertyName);
        Mockito.when((Object)somePropertyParameterModel.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        ComponentParameterAst propertyParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)propertyParam.getRawValue()).thenReturn((Object)("#[vars." + propertyName + "]"));
        Mockito.when((Object)propertyParam.getModel()).thenReturn((Object)somePropertyParameterModel);
        ComponentAst innerConnectionProviderComponentObject = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)innerConnectionProviderComponentObject.getParameters()).thenReturn(Collections.singleton(propertyParam));
        MetadataTypeAdapter complexTypeAdapter = (MetadataTypeAdapter)Mockito.mock(MetadataTypeAdapter.class);
        Mockito.when((Object)complexTypeAdapter.getType()).thenReturn((Object)this.complexType);
        Mockito.when((Object)innerConnectionProviderComponentObject.getModel(MetadataTypeAdapter.class)).thenReturn(Optional.of(complexTypeAdapter));
        ComponentAst innerConnectionProviderComponent = (ComponentAst)Mockito.mock(ComponentAst.class);
        ParameterModel someObjectParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)someObjectParameterModel.getName()).thenReturn((Object)"object");
        Mockito.when((Object)someObjectParameterModel.getType()).thenReturn((Object)this.complexType);
        ComponentParameterAst complexParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)complexParam.getRawValue()).thenReturn(null);
        Mockito.when((Object)complexParam.getValue()).thenReturn((Object)Either.right((Object)innerConnectionProviderComponentObject));
        Mockito.when((Object)complexParam.getModel()).thenReturn((Object)someObjectParameterModel);
        Mockito.when((Object)innerConnectionProviderComponent.getParameters()).thenReturn(Collections.singleton(complexParam));
        Mockito.when((Object)innerConnectionProviderComponent.recursiveStream()).thenReturn(Stream.concat(Stream.of(innerConnectionProviderComponent), Stream.of(innerConnectionProviderComponentObject)));
        return innerConnectionProviderComponent;
    }

    public static class TestConnectionProvider
    implements ConnectionProvider {
        private Object object;
        private String someProperty;

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public String getSomeProperty() {
            return this.someProperty;
        }

        public void setSomeProperty(String someProperty) {
            this.someProperty = someProperty;
        }

        public Object connect() throws ConnectionException {
            return null;
        }

        public void disconnect(Object connection) {
        }

        public ConnectionValidationResult validate(Object connection) {
            return null;
        }
    }

    public static class TestConnectionProviderWrapper
    extends XmlSdkConnectionProviderWrapper {
        private String someProperty;

        public TestConnectionProviderWrapper(ComponentAst innerConnectionProviderComponent, Function propertyUsage) {
            super(innerConnectionProviderComponent, propertyUsage);
        }

        public String getSomeProperty() {
            return this.someProperty;
        }

        public void setSomeProperty(String someProperty) {
            this.someProperty = someProperty;
        }
    }
}

