/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Issue;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;

public class ModuleWithPropertiesTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @Override
    protected String getModulePath() {
        return "modules/module-properties.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-using-module-properties.xml";
    }

    @Test
    public void testSetPayloadHardcodedFromModuleFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadHardcodedFromModuleFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hardcoded value from module"));
    }

    @Test
    public void testSetPayloadParamFromModuleFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadParamFromModuleFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"new payload from module"));
    }

    @Test
    public void testSetPayloadConfigParamFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadConfigParamFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"some config-value-parameter"));
    }

    @Test
    public void testSetPayloadConfigDefaultParamFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadConfigDefaultParamFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"some default-config-value-parameter"));
    }

    @Test
    public void testSetPayloadConfigDefaultPropertyUseOptionalFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadConfigDefaultPropertyUseOptionalFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"some default-config-value-parameter"));
    }

    @Test
    public void testSetPayloadAddParamAndPropertyValues() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadAddParamAndPropertyValues").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"a parameter value some config-value-parameter"));
    }

    @Test
    public void testSetPayloadConfigOptionalProperty() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadConfigOptionalProperty").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetPayloadHardcodedGlobalProperty() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadHardcodedGlobalProperty").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"a-constant-global-value"));
    }

    @Test
    public void testSetPayloadHardcodedSystemProperty() throws Exception {
        String expected_value = System.getProperty("user.home");
        CoreEvent muleEvent = this.flowRunner("testSetPayloadHardcodedSystemProperty").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)expected_value));
    }

    @Test
    public void testSetPayloadHardcodedFileProperty() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadHardcodedFileProperty").run();
        String expectedContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("modules/module-properties-file.txt")).trim();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)expectedContent));
    }

    @Test
    @Issue(value="MULE-19035")
    public void testSetPayloadAddParamAndPropertyValueThruInternalOperationFlow() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadAddParamAndPropertyValueThruInternalOperationFlow").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"a parameter value some config-value-parameter"));
    }

    @Test
    @Issue(value="MULE-19962")
    public void testSetPayloadPropertiesCallingNestedOperations() throws Exception {
        CoreEvent muleEvent = this.flowRunner("testSetPayloadPropertiesCallingNestedOperations").run();
        MatcherAssert.assertThat((Object)muleEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"What are these? These are two nice properties, some default-config-value-parameter and some default-config-value-parameter"));
    }
}

