/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.error.Errors;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.marvel.drstrange.CustomErrorException;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;

@Feature(value="Error Handling")
@Story(value="Raise Errors")
public class ModuleUsingRaiseErrorTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @Override
    protected String getModulePath() {
        return "modules/module-using-raise-error.xml";
    }

    protected String getConfigFile() {
        return "flows/flows-with-module-using-raise-error.xml";
    }

    @Test
    public void muleStaticErrorRaised() throws Exception {
        this.verifyResultFrom("simple", "Could not connect: A module error occurred.");
    }

    @Test
    public void customStaticErrorRaised() throws Exception {
        this.verifyResultFrom("complex", "Custom error: A custom error occurred.");
    }

    @Test
    public void customErrorCanBeMapped() throws Exception {
        this.verifyResultFrom("complexMapping", "Handled");
    }

    @Test
    public void simpleWithNoHandling() throws Exception {
        String flowName = "simpleWithNoHandlingFlow";
        MuleException me = (MuleException)this.flowRunner("simpleWithNoHandlingFlow").runExpectingException();
        this.stopFlowConstruct("simpleWithNoHandlingFlow");
        MatcherAssert.assertThat((Object)me.getMessage(), (Matcher)CoreMatchers.is((Object)"A module error occurred."));
        MatcherAssert.assertThat((Object)me.getExceptionInfo().getErrorType().toString(), (Matcher)CoreMatchers.is((Object)Errors.ComponentIdentifiers.Handleable.CONNECTIVITY.toString()));
        MatcherAssert.assertThat(me.getInfo().get("Element DSL"), (Matcher)CoreMatchers.is((Object)"<module-using-raise-error:fail-raise-error></module-using-raise-error:fail-raise-error>"));
        MatcherAssert.assertThat(me.getInfo().get("Element"), (Matcher)CoreMatchers.is((Object)"simpleWithNoHandlingFlow/processors/0 @ ModuleUsingRaiseErrorTestCase#simpleWithNoHandling:flows/flows-with-module-using-raise-error.xml:47"));
    }

    @Test
    public void simpleWithCustomJavaException() throws Exception {
        String flowName = "simpleWithCustomJavaExceptionFlow";
        MuleException me = (MuleException)((FlowRunner)this.flowRunner("simpleWithCustomJavaExceptionFlow").withVariable("food", null)).runExpectingException();
        this.stopFlowConstruct("simpleWithCustomJavaExceptionFlow");
        MatcherAssert.assertThat((Object)me.getMessage(), (Matcher)CoreMatchers.is((Object)"java.lang.NullPointerException"));
        MatcherAssert.assertThat((Object)me.getExceptionInfo().getErrorType().toString(), (Matcher)CoreMatchers.is((Object)ComponentIdentifier.builder().namespace("Marvel".toUpperCase()).name(DrStrangeErrorTypeDefinition.CUSTOM_ERROR.toString()).build().toString()));
        MatcherAssert.assertThat(me.getInfo().get("Element DSL"), (Matcher)CoreMatchers.is((Object)"<module-using-raise-error:fail-custom-exception content=\"#[vars.food]\"></module-using-raise-error:fail-custom-exception>"));
        MatcherAssert.assertThat(me.getInfo().get("Element"), (Matcher)CoreMatchers.is((Object)"simpleWithCustomJavaExceptionFlow/processors/0 @ ModuleUsingRaiseErrorTestCase#simpleWithCustomJavaException:flows/flows-with-module-using-raise-error.xml:51"));
        MatcherAssert.assertThat((Object)me.getCause(), (Matcher)CoreMatchers.instanceOf(CustomErrorException.class));
    }

    private void verifyResultFrom(String flowName, String expectedPayload) throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner(flowName).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)expectedPayload)));
    }
}

