/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaExecutableComponentModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.internal.runtime.function.ReflectiveFunctionExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.ExpressionFunctions;

public class JavaFunctionModelParser
extends AbstractJavaExecutableComponentModelParser
implements FunctionModelParser {
    private final FunctionElement functionElement;

    public JavaFunctionModelParser(ExtensionElement extensionElement, FunctionElement functionElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.functionElement = functionElement;
        if (!this.isIgnored()) {
            this.parseStructure();
            this.collectAdditionalModelProperties();
        }
    }

    @Override
    public String getName() {
        return this.functionElement.getAlias();
    }

    @Override
    public String getDescription() {
        return this.functionElement.getDescription();
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return JavaExtensionModelParserUtils.getParameterGroupParsers(this.functionElement.getParameters(), ParameterDeclarationContext.forFunction(this.getName(), this.loadingContext));
    }

    @Override
    public boolean isIgnored() {
        return IntrospectionUtils.isIgnored(this.functionElement, this.loadingContext);
    }

    @Override
    public Optional<FunctionExecutorModelProperty> getFunctionExecutorModelProperty() {
        if (this.functionElement.getMethod().isPresent()) {
            return Optional.of(new FunctionExecutorModelProperty(new ReflectiveFunctionExecutorFactory((Class)this.functionElement.getDeclaringClass().get(), this.functionElement.getMethod().get())));
        }
        return Optional.empty();
    }

    @Override
    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        SemanticTermsParserUtils.addCustomTerms(this.functionElement, terms);
        return terms;
    }

    @Override
    protected String getComponentTypeName() {
        return "Function";
    }

    private void collectAdditionalModelProperties() {
        this.functionElement.getMethod().map(ImplementingMethodModelProperty::new).ifPresent(this.additionalModelProperties::add);
    }

    private void parseStructure() {
        this.checkIsNotAnExtension();
        Optional<ExtensionParameter> configParameter = JavaExtensionModelParserUtils.getConfigParameter(this.functionElement);
        if (configParameter.isPresent()) {
            throw new IllegalModelDefinitionException(String.format("Function '%s' requires a config parameter, but that is not allowed. Remove such parameter.", this.getName()));
        }
        this.outputType = new DefaultOutputModelParser(this.functionElement.getReturnMetadataType(), false);
    }

    private void checkIsNotAnExtension() {
        FunctionContainerElement type = this.functionElement.getEnclosingType();
        if (type.isAssignableFrom(this.extensionElement) || this.extensionElement.isAssignableFrom(type)) {
            throw new IllegalOperationModelDefinitionException(String.format("Function class '%s' cannot be the same class (nor a derivative) of the extension class '%s", type.getName(), this.extensionElement.getName()));
        }
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.functionElement);
    }

    @Override
    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.of(MinMuleVersionUtils.resolveFunctionMinMuleVersion(this.functionElement, MinMuleVersionUtils.getContainerAnnotationMinMuleVersion(this.extensionElement, ExpressionFunctions.class, ExpressionFunctions::value, this.functionElement.getEnclosingType())));
    }

    public boolean equals(Object o) {
        if (o instanceof JavaFunctionModelParser) {
            return this.functionElement.equals(((JavaFunctionModelParser)o).functionElement);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.functionElement);
    }
}

