/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderFactory;

public final class ValueProviderFactoryModelProperty
implements ModelProperty {
    private final Field connectionField;
    private final Field configField;
    private final Class<?> valuesProvider;
    private final List<InjectableParameterInfo> injectableParameters;

    private ValueProviderFactoryModelProperty(Class<?> valueProvider, List<InjectableParameterInfo> injectableParameters, Field connectionField, Field configField) {
        Preconditions.checkNotNull(valueProvider, (String)"Values Provider Class parameter can't be null");
        Preconditions.checkNotNull(injectableParameters, (String)"injectableParameters parameter can't be null");
        this.valuesProvider = valueProvider;
        this.injectableParameters = injectableParameters;
        this.connectionField = connectionField;
        this.configField = configField;
    }

    public static ValueProviderFactoryModelPropertyBuilder builder(Class valuesProvider) {
        return new ValueProviderFactoryModelPropertyBuilder(valuesProvider);
    }

    public String getName() {
        return "ValueProviderFactory";
    }

    public boolean isPublic() {
        return false;
    }

    public Class<?> getValueProvider() {
        return this.valuesProvider;
    }

    public List<String> getRequiredParameters() {
        return this.injectableParameters.stream().map(InjectableParameterInfo::getParameterName).collect(Collectors.toList());
    }

    public List<InjectableParameterInfo> getInjectableParameters() {
        return this.injectableParameters;
    }

    public boolean usesConnection() {
        return this.connectionField != null;
    }

    public boolean usesConfig() {
        return this.configField != null;
    }

    public ValueProviderFactory createFactory(ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ReflectionCache reflectionCache, MuleContext muleContext, ParameterizedModel parameterizedModel) {
        return new ValueProviderFactory(this, parameterValueResolver, connectionSupplier, configurationSupplier, this.connectionField, this.configField, reflectionCache, muleContext, parameterizedModel);
    }

    public static class ValueProviderFactoryModelPropertyBuilder {
        private final Class<?> dynamicOptionsResolver;
        private final List<InjectableParameterInfo> injectableParameters;
        private Field connectionField;
        private Field configField;

        ValueProviderFactoryModelPropertyBuilder(Class<?> dynamicOptionsResolver) {
            this.dynamicOptionsResolver = dynamicOptionsResolver;
            this.injectableParameters = new ArrayList<InjectableParameterInfo>();
        }

        public ValueProviderFactoryModelPropertyBuilder withInjectableParameter(String name, MetadataType metadataType, boolean isRequired) {
            return this.withInjectableParameter(name, metadataType, isRequired, name);
        }

        public ValueProviderFactoryModelPropertyBuilder withInjectableParameter(String name, MetadataType metadataType, boolean isRequired, String extractionExpression) {
            this.injectableParameters.add(new InjectableParameterInfo(name, metadataType, isRequired, extractionExpression));
            return this;
        }

        public ValueProviderFactoryModelProperty build() {
            return new ValueProviderFactoryModelProperty(this.dynamicOptionsResolver, this.injectableParameters, this.connectionField, this.configField);
        }

        public void withConnection(Field connectionField) {
            this.connectionField = connectionField;
        }

        public void withConfig(Field configField) {
            this.configField = configField;
        }
    }
}

