/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ImmutableClientCredentialsState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.exception.TokenInvalidatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatingClientCredentialsState
implements ClientCredentialsState,
org.mule.sdk.api.connectivity.oauth.ClientCredentialsState {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatingClientCredentialsState.class);
    private static final boolean INVALIDATE_POTENTIAL_NULL = Boolean.getBoolean("mule.oauth.token.nullcheck");
    private final ClientCredentialsOAuthDancer dancer;
    private ClientCredentialsState delegate;
    private boolean invalidated = false;
    private ClientCredentialsListener clientCredentialsListener;

    public UpdatingClientCredentialsState(ClientCredentialsOAuthDancer dancer, ResourceOwnerOAuthContext initialContext, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.dancer = dancer;
        this.updateDelegate(initialContext);
        this.clientCredentialsListener = new ClientCredentialsListener(){

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                LOGGER.debug("Token has been refreshed");
                UpdatingClientCredentialsState.this.updateDelegate(context);
                onUpdate.accept(context);
            }

            public void onTokenInvalidated() {
                LOGGER.debug("Stored token is invalidated");
                UpdatingClientCredentialsState.this.invalidated = true;
            }
        };
        dancer.addListener(this.clientCredentialsListener);
    }

    private void updateDelegate(ResourceOwnerOAuthContext initialContext) {
        String accessToken = initialContext.getAccessToken();
        String expiresIn = initialContext.getExpiresIn();
        if (accessToken == null && INVALIDATE_POTENTIAL_NULL) {
            LOGGER.warn("Null token was set in the ResourceOwnerOAuthContext. Using previous token, and ensuring this state stays invalidated for next attempt");
            this.invalidated = true;
            return;
        }
        this.delegate = new ImmutableClientCredentialsState(accessToken, expiresIn);
        this.invalidated = false;
    }

    public String getAccessToken() {
        if (this.invalidated) {
            try {
                LOGGER.debug("Stored AccessToken in UpdatingClientCredentialsState was invalidated, retrieving another from the OAuth Dancer");
                this.dancer.accessToken().get();
                this.updateDelegate(this.dancer.getContext());
            }
            catch (Exception e) {
                throw new TokenInvalidatedException("Access Token has been invalidated and failed to obtain a new one", e);
            }
        }
        return this.delegate.getAccessToken();
    }

    public Optional<String> getExpiresIn() {
        return this.delegate.getExpiresIn();
    }

    public void deregisterListener() {
        this.dancer.removeListener(this.clientCredentialsListener);
    }
}

