/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.interceptor;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LinkedInterceptorChain
implements InterceptorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedInterceptorChain.class);
    private static final String BEFORE = "before";
    private static final String ON_SUCCESS = "onSuccess";
    private static final String ON_ERROR = "onError";
    private static final String AFTER = "after";
    private final Interceptor interceptor;
    private LinkedInterceptorChain next;
    private LinkedInterceptorChain previous;

    static LinkedInterceptorChain of(List<Interceptor> interceptors) {
        List chains = interceptors.stream().map(LinkedInterceptorChain::new).collect(Collectors.toList());
        LinkedInterceptorChain interceptor = (LinkedInterceptorChain)chains.get(0);
        LinkedInterceptorChain previous = null;
        int len = chains.size();
        for (int i = 0; i < len; ++i) {
            LinkedInterceptorChain next;
            interceptor.previous = previous;
            previous = interceptor;
            int nextIndex = i + 1;
            interceptor.next = next = nextIndex < len ? (LinkedInterceptorChain)chains.get(nextIndex) : null;
            interceptor = next;
        }
        return (LinkedInterceptorChain)chains.get(0);
    }

    private LinkedInterceptorChain(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public Throwable before(ExecutionContext executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
        try {
            this.interceptor.before(executionContext);
            if (this.next != null) {
                return this.next.before(executionContext, callback);
            }
            return null;
        }
        catch (Throwable t) {
            this.logError(t, BEFORE, false);
            t = this.errorOnReverse(executionContext, t);
            if (callback != null) {
                callback.error(t);
            }
            return t;
        }
    }

    @Override
    public void onSuccess(ExecutionContext executionContext, Object result) {
        try {
            this.interceptor.onSuccess(executionContext, result);
        }
        catch (Throwable t) {
            this.logError(t, ON_SUCCESS, true);
        }
        try {
            this.interceptor.after(executionContext, result);
        }
        catch (Throwable t) {
            this.logError(t, AFTER, true);
        }
        if (this.next != null) {
            this.next.onSuccess(executionContext, result);
        }
    }

    @Override
    public Throwable onError(ExecutionContext executionContext, Throwable t) {
        try {
            t = this.interceptor.onError(executionContext, t);
        }
        catch (Throwable t2) {
            this.logError(t2, ON_ERROR, true);
        }
        try {
            this.interceptor.after(executionContext, null);
        }
        catch (Throwable t2) {
            this.logError(t2, AFTER, true);
        }
        if (this.next != null) {
            t = this.next.onError(executionContext, t);
        }
        return t;
    }

    @Override
    public void abort(ExecutionContext executionContext) {
        try {
            this.interceptor.after(executionContext, null);
        }
        catch (Throwable t) {
            this.logError(t, AFTER, true);
        }
        if (this.next != null) {
            this.next.abort(executionContext);
        }
    }

    private Throwable errorOnReverse(ExecutionContext executionContext, Throwable t) {
        try {
            t = this.interceptor.onError(executionContext, t);
        }
        catch (Throwable t2) {
            this.logError(t2, ON_ERROR, true);
        }
        try {
            this.interceptor.after(executionContext, null);
        }
        catch (Throwable t2) {
            this.logError(t2, AFTER, true);
        }
        if (this.previous != null) {
            return this.previous.errorOnReverse(executionContext, t);
        }
        return t;
    }

    private void logError(Throwable t, String phase, boolean executionContinues) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Interceptor %s threw exception executing '%s' phase.", this.interceptor, phase));
            if (executionContinues) {
                builder.append(" Exception will be ignored. Next interceptors (if any) will be executed and the operation's exception will be returned");
            }
            LOGGER.debug(builder.toString(), t);
        }
    }
}

