/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaFunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.Alias;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class JavaFunctionModelParserTestCase {
    protected JavaFunctionModelParser parser;
    protected FunctionElement functionElement;
    ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());

    @Test
    public void getMMVForFunction() throws NoSuchMethodException {
        this.setParser(Functions.class.getMethod("function", new Class[0]), ConfigurationFunctions.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)Matchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Function function has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForSdkAnnotatedFunction() throws NoSuchMethodException {
        this.setParser(SdkFunctions.class.getMethod("sdkFunction", new Class[0]), ConfigurationFunctions.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method sdkFunction has min mule version 4.5.0 because it is annotated with Alias. Alias was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForFunctionFromConfigurationWithSdkFunctionsAnnotation() throws NoSuchMethodException {
        this.setParser(Functions.class.getMethod("function", new Class[0]), ConfigurationWithSdkFunctionsAnnotation.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Function function has min mule version 4.5.0 because it was propagated from the @Functions annotation at the extension class used to add the function."));
    }

    protected void setParser(Method method, Class<?> extensionClass) {
        this.functionElement = new FunctionWrapper(method, this.typeLoader);
        this.parser = new JavaFunctionModelParser((ExtensionElement)new ExtensionTypeWrapper(extensionClass, ExtensionsTestUtils.TYPE_LOADER), this.functionElement, MinMuleVersionTestUtils.ctxResolvingMinMuleVersion());
    }

    private class Functions {
        private Functions() {
        }

        public void function() {
        }
    }

    @ExpressionFunctions(value={Functions.class, SdkFunctions.class})
    private class ConfigurationFunctions {
        private ConfigurationFunctions() {
        }
    }

    private class SdkFunctions {
        private SdkFunctions() {
        }

        @Alias(value="alias")
        public void sdkFunction() {
        }
    }

    @org.mule.sdk.api.annotation.ExpressionFunctions(value={Functions.class})
    private class ConfigurationWithSdkFunctionsAnnotation {
        private ConfigurationWithSdkFunctionsAnnotation() {
        }
    }
}

