/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.JavaConnectionProviderModelParserTestCase;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.values.ValuePart;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.parameter.CorrelationInfo;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class JavaOperationModelParserTestCase {
    protected JavaOperationModelParser parser;
    protected OperationElement operationElement;

    @Test
    public void parseTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), TransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)this.parser.isTransactional(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void parseSdkTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SdkTransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)this.parser.isTransactional(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getMMVForVanillaOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), TransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)Matchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Operation transactionalOperation has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForOperationAnnotatedWithMMV() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "annotatedWithMMV", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method annotatedWithMMV has min mule version 4.4 because it is the one set at the method level through the @MinMuleVersion annotation."));
    }

    @Test
    public void getOverwrittenMMVForOperationAnnotatedWithMMV() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "overwriteMMV", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Calculated Min Mule Version is 4.5.0 which is greater than the one set at the method level 4.4. Overriding it. Method overwriteMMV has min mule version 4.5.0 because it is annotated with Alias. Alias was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForOperationWithSdkParameter() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withSdkParameter", Literal.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withSdkParameter has min mule version 4.5.0 because of its parameter literalParameter. Parameter literalParameter has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForOperationWithSdkImplicitParameter() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withSdkImplicitParameter", CorrelationInfo.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withSdkImplicitParameter has min mule version 4.5.0 because of its parameter info. Parameter info has min mule version 4.5.0 because it is of type CorrelationInfo. CorrelationInfo was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForOperationWithSdkAnnotatedParameter() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withSdkAnnotatedParameter", String.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)this.getMessageForOperationWithSdkAnnotatedParameter()));
    }

    @Test
    public void getMMVForOperationWithParameterGroup() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withParameterGroup", ParameterGroup.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)this.getMessageForOperationWithParameterGroup()));
    }

    @Test
    public void getMMVForOperationWithParameterGroupWithValueAnnotation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withGroupAsMultiLevelValue", GroupAsMultiLevelValue.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)this.getMessageForOperationWithParameterGroupWithValueAnnotation()));
    }

    @Test
    public void getMMVForOperationWithParameterGroupWithLiteralField() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withGroupWithLiteralField", ParameterGroupWithLiteralField.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)this.getMessageForOperationWithParameterGroupWithLiteralField()));
    }

    @Test
    public void getMMVForOperationWithParameterContainer() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withParameterContainer", ParameterGroup.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withParameterContainer has min mule version 4.4 because of its parameter parameterContainer. Parameter parameterContainer has min mule version 4.4 because it is of type ParameterGroup. Type ParameterGroup has min mule version 4.4 because of its field someField. Field someField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForOperationWithConfigParameter() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withConfigParameter", SomeConfiguration.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)this.getMessageOperationWithConfigParameter()));
    }

    @Test
    public void getMMVForOperationWithSdkPagingProvider() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withSdkPagingProvider", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withSdkPagingProvider has min mule version 4.4 because of its output type PagingProvider. PagingProvider was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForOperationWithPagingProviderSdkGeneric() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withPagingProviderSdkGeneric", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withPagingProviderSdkGeneric has min mule version 4.4 because of its output type Result. Result was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForOperationWithResultOutput() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withResultOutput", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withResultOutput has min mule version 4.4 because of its output type Result. Result was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVLegacyApiTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), TransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.1.1"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Operation transactionalOperation has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVLegacySdkApiTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SdkTransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)Matchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Operation transactionalOperation has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForParameterizedOperationsContainer() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), ParameterizedOperations.class, "noArgumentsOperation", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Operation noArgumentsOperation has min mule version 4.4 because of its parameter containerParameter. Parameter containerParameter has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForOperationFromConfigurationWithSdkOperationsAnnotation() throws NoSuchMethodException {
        this.parseOperation(this.getExtensionElement(ConfigurationWithSdkOperationsAnnotation.class), TransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Operation transactionalOperation has min mule version 4.4.0 because it was propagated from the @Operations annotation at the extension class used to add the operation's container TransactionalOperations."));
    }

    @Test
    public void getMMVForOperationWithArrayListOutput() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withArrayListOutput", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withArrayListOutput has min mule version 4.5.0 because of its output type Literal. Literal was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForOperationWithNativeArrayOutput() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SkdOperations.class, "withNativeArrayOutput", new Class[0]);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)Matchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)this.parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)Matchers.is((Object)"Method withNativeArrayOutput has min mule version 4.4 because of its output type Result. Result was introduced in Mule 4.4."));
    }

    public void parseOperation(ExtensionElement extensionElement, Class<?> operationClass, String methodName, Class<?> ... parameterType) throws NoSuchMethodException {
        Method method = operationClass.getMethod(methodName, parameterType);
        this.operationElement = new OperationWrapper(method, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        this.parser = new JavaOperationModelParser((JavaExtensionModelParser)Mockito.mock(JavaExtensionModelParser.class), extensionElement, (OperationContainerElement)Mockito.mock(OperationContainerElement.class), this.operationElement, MinMuleVersionTestUtils.ctxResolvingMinMuleVersion());
    }

    protected ExtensionElement getExtensionElement(Class<?> extensionClass) {
        return new ExtensionTypeWrapper(extensionClass, ExtensionsTestUtils.TYPE_LOADER);
    }

    protected String getMessageForOperationWithSdkAnnotatedParameter() {
        return "Method withSdkAnnotatedParameter has min mule version 4.4 because of its parameter optionalParameter. Parameter optionalParameter has min mule version 4.4 because it is annotated with Optional. Optional was introduced in Mule 4.4.";
    }

    protected String getMessageOperationWithConfigParameter() {
        return "Method withConfigParameter has min mule version 4.4 because of its parameter configParameter. Parameter configParameter has min mule version 4.4 because it references a config of type SomeConfiguration. Configuration SomeConfiguration has min mule version 4.4 because of its field configField. Field configField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4.";
    }

    protected String getMessageForOperationWithParameterGroup() {
        return "Method withParameterGroup has min mule version 4.4 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.4 because it is of type ParameterGroup. Type ParameterGroup has min mule version 4.4 because of its field someField. Field someField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4.";
    }

    protected String getMessageForOperationWithParameterGroupWithLiteralField() {
        return "Method withGroupWithLiteralField has min mule version 4.5.0 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.5.0 because it is of type ParameterGroupWithLiteralField. Type ParameterGroupWithLiteralField has min mule version 4.5.0 because of its field anotherField. Field anotherField has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0.";
    }

    protected String getMessageForOperationWithParameterGroupWithValueAnnotation() {
        return "Method withGroupAsMultiLevelValue has min mule version 4.5 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.5 because it is of type GroupAsMultiLevelValue. Type GroupAsMultiLevelValue has min mule version 4.5 because of its field country. Field country has min mule version 4.5 because it is annotated with ValuePart. ValuePart was introduced in Mule 4.5.";
    }

    private class TransactionalOperations {
        private TransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.TestTransactionalConnection connection) {
        }
    }

    private static class SdkTransactionalOperations {
        private SdkTransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection connection) {
        }
    }

    private static class SkdOperations {
        private SkdOperations() {
        }

        @MinMuleVersion(value="4.4")
        public void annotatedWithMMV() {
        }

        @MinMuleVersion(value="4.4")
        @Alias(value="operation alias")
        public void overwriteMMV() {
        }

        public void withSdkParameter(Literal<String> literalParameter) {
        }

        public void withSdkImplicitParameter(CorrelationInfo info) {
        }

        public void withSdkAnnotatedParameter(@Optional String optionalParameter) {
        }

        public void withParameterGroup(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") ParameterGroup parameterGroup) {
        }

        public void withParameterContainer(ParameterGroup parameterContainer) {
        }

        public void withGroupAsMultiLevelValue(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") GroupAsMultiLevelValue parameterGroup) {
        }

        public void withGroupWithLiteralField(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") ParameterGroupWithLiteralField parameterGroup) {
        }

        public org.mule.sdk.api.runtime.streaming.PagingProvider<String, String> withSdkPagingProvider() {
            return new org.mule.sdk.api.runtime.streaming.PagingProvider<String, String>(){

                public List<String> getPage(String connection) {
                    return null;
                }

                public java.util.Optional<Integer> getTotalResults(String connection) {
                    return java.util.Optional.empty();
                }

                public void close(String connection) throws MuleException {
                }
            };
        }

        public PagingProvider<String, Result<String, Void>> withPagingProviderSdkGeneric() {
            return new PagingProvider<String, Result<String, Void>>(){

                public List<Result<String, Void>> getPage(String connection) {
                    return null;
                }

                public java.util.Optional<Integer> getTotalResults(String connection) {
                    return java.util.Optional.empty();
                }

                public void close(String connection) throws MuleException {
                }
            };
        }

        public Result<String, Void> withResultOutput() {
            return Result.builder().build();
        }

        public ArrayList<Literal<String>> withArrayListOutput() {
            return new ArrayList<Literal<String>>();
        }

        public Result<String, Void>[] withNativeArrayOutput() {
            return new Result[1];
        }

        public void withConfigParameter(@Config SomeConfiguration configParameter) {
        }
    }

    public static class ParameterGroup {
        @Parameter
        String someField;
        @Parameter
        String anotherField;
    }

    public static class GroupAsMultiLevelValue {
        @Parameter
        @org.mule.runtime.extension.api.annotation.values.ValuePart(order=1)
        private String continent;
        @Parameter
        @ValuePart(order=2)
        private String country;
    }

    public static class ParameterGroupWithLiteralField {
        @Parameter
        String someField;
        @Parameter
        Literal<String> anotherField;
    }

    private static class SomeConfiguration {
        @Parameter
        String configField;

        private SomeConfiguration() {
        }
    }

    private static class ParameterizedOperations {
        @Parameter
        String containerParameter;

        private ParameterizedOperations() {
        }

        public void noArgumentsOperation() {
        }
    }

    @Extension(name="Configuration With Sdk Operations Annotation")
    @Operations(value={TransactionalOperations.class})
    private static class ConfigurationWithSdkOperationsAnnotation {
        private ConfigurationWithSdkOperationsAnnotation() {
        }
    }
}

