/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.JavaConnectionProviderModelParserTestCase;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.values.ValuePart;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.parameter.CorrelationInfo;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class JavaOperationModelParserTestCase {
    protected JavaOperationModelParser parser;
    protected OperationElement operationElement;

    @Test
    public void parseTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), TransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.TestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)this.parser.isTransactional(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void parseSdkTransactionalOperation() throws NoSuchMethodException {
        this.parseOperation((ExtensionElement)Mockito.mock(ExtensionElement.class), SdkTransactionalOperations.class, "transactionalOperation", JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection.class);
        MatcherAssert.assertThat((Object)this.parser.isTransactional(), (Matcher)Matchers.is((Object)true));
    }

    public void parseOperation(ExtensionElement extensionElement, Class<?> operationClass, String methodName, Class<?> ... parameterType) throws NoSuchMethodException {
        Method method = operationClass.getMethod(methodName, parameterType);
        this.operationElement = new OperationWrapper(method, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        this.parser = new JavaOperationModelParser((JavaExtensionModelParser)Mockito.mock(JavaExtensionModelParser.class), extensionElement, (OperationContainerElement)Mockito.mock(OperationContainerElement.class), this.operationElement, MinMuleVersionTestUtils.ctxResolvingMinMuleVersion());
    }

    protected ExtensionElement getExtensionElement(Class<?> extensionClass) {
        return new ExtensionTypeWrapper(extensionClass, ExtensionsTestUtils.TYPE_LOADER);
    }

    protected String getMessageForOperationWithSdkAnnotatedParameter() {
        return "Method withSdkAnnotatedParameter has min mule version 4.4 because of its parameter optionalParameter. Parameter optionalParameter has min mule version 4.4 because it is annotated with Optional. Optional was introduced in Mule 4.4.";
    }

    protected String getMessageOperationWithConfigParameter() {
        return "Method withConfigParameter has min mule version 4.4 because of its parameter configParameter. Parameter configParameter has min mule version 4.4 because it references a config of type SomeConfiguration. Configuration SomeConfiguration has min mule version 4.4 because of its field configField. Field configField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4.";
    }

    protected String getMessageForOperationWithParameterGroup() {
        return "Method withParameterGroup has min mule version 4.4 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.4 because it is of type ParameterGroup. Type ParameterGroup has min mule version 4.4 because of its field someField. Field someField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4.";
    }

    protected String getMessageForOperationWithParameterGroupWithLiteralField() {
        return "Method withGroupWithLiteralField has min mule version 4.5.0 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.5.0 because it is of type ParameterGroupWithLiteralField. Type ParameterGroupWithLiteralField has min mule version 4.5.0 because of its field anotherField. Field anotherField has min mule version 4.5.0 because it is of type Literal. Literal was introduced in Mule 4.5.0.";
    }

    protected String getMessageForOperationWithParameterGroupWithValueAnnotation() {
        return "Method withGroupAsMultiLevelValue has min mule version 4.5 because of its parameter parameterGroup. Parameter parameterGroup has min mule version 4.5 because it is of type GroupAsMultiLevelValue. Type GroupAsMultiLevelValue has min mule version 4.5 because of its field country. Field country has min mule version 4.5 because it is annotated with ValuePart. ValuePart was introduced in Mule 4.5.";
    }

    public static class GroupAsMultiLevelValue {
        @Parameter
        @org.mule.runtime.extension.api.annotation.values.ValuePart(order=1)
        private String continent;
        @Parameter
        @ValuePart(order=2)
        private String country;
    }

    public static class ParameterGroupWithLiteralField {
        @Parameter
        String someField;
        @Parameter
        Literal<String> anotherField;
    }

    public static class ParameterGroup {
        @Parameter
        String someField;
        @Parameter
        String anotherField;
    }

    @Extension(name="Configuration With Sdk Operations Annotation")
    @Operations(value={TransactionalOperations.class})
    private static class ConfigurationWithSdkOperationsAnnotation {
        private ConfigurationWithSdkOperationsAnnotation() {
        }
    }

    private static class SomeConfiguration {
        @Parameter
        String configField;

        private SomeConfiguration() {
        }
    }

    private static class ParameterizedOperations {
        @Parameter
        String containerParameter;

        private ParameterizedOperations() {
        }

        public void noArgumentsOperation() {
        }
    }

    private static class SkdOperations {
        private SkdOperations() {
        }

        @MinMuleVersion(value="4.4")
        public void annotatedWithMMV() {
        }

        @MinMuleVersion(value="4.4")
        @Alias(value="operation alias")
        public void overwriteMMV() {
        }

        public void withSdkParameter(Literal<String> literalParameter) {
        }

        public void withSdkImplicitParameter(CorrelationInfo info) {
        }

        public void withSdkAnnotatedParameter(@Optional String optionalParameter) {
        }

        public void withParameterGroup(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") ParameterGroup parameterGroup) {
        }

        public void withParameterContainer(ParameterGroup parameterContainer) {
        }

        public void withGroupAsMultiLevelValue(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") GroupAsMultiLevelValue parameterGroup) {
        }

        public void withGroupWithLiteralField(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="pg") ParameterGroupWithLiteralField parameterGroup) {
        }

        public org.mule.sdk.api.runtime.streaming.PagingProvider<String, String> withSdkPagingProvider() {
            return new org.mule.sdk.api.runtime.streaming.PagingProvider<String, String>(){

                public List<String> getPage(String connection) {
                    return null;
                }

                public java.util.Optional<Integer> getTotalResults(String connection) {
                    return java.util.Optional.empty();
                }

                public void close(String connection) throws MuleException {
                }
            };
        }

        public PagingProvider<String, Result<String, Void>> withPagingProviderSdkGeneric() {
            return new PagingProvider<String, Result<String, Void>>(){

                public List<Result<String, Void>> getPage(String connection) {
                    return null;
                }

                public java.util.Optional<Integer> getTotalResults(String connection) {
                    return java.util.Optional.empty();
                }

                public void close(String connection) throws MuleException {
                }
            };
        }

        public Result<String, Void> withResultOutput() {
            return Result.builder().build();
        }

        public ArrayList<Literal<String>> withArrayListOutput() {
            return new ArrayList<Literal<String>>();
        }

        public Result<String, Void>[] withNativeArrayOutput() {
            return new Result[1];
        }

        public void withConfigParameter(@Config SomeConfiguration configParameter) {
        }
    }

    private static class SdkTransactionalOperations {
        private SdkTransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.SdkTestTransactionalConnection connection) {
        }
    }

    private class TransactionalOperations {
        private TransactionalOperations() {
        }

        public void transactionalOperation(@Connection JavaConnectionProviderModelParserTestCase.TestTransactionalConnection connection) {
        }
    }
}

