/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.Configurations;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.PrivilegedExport;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.vegan.extension.VeganCookBook;

public class JavaExtensionModelParserTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Issue(value="W-12622240")
    @Description(value="Verify that ExtensionModel for an Extension with java data types such as LocalDateTime, loads the correct MetadataType i.e. DateTimeType and works in Java 17")
    public void getParameterizedWithJavaFieldsExtensionUsingSdkApi() throws Exception {
        ExtensionModel extensionModel = MuleExtensionUtils.loadExtension(ParameterizedWithJavaTypeExtension.class);
        ConfigurationModel configModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        ParameterModel parameterModel = (ParameterModel)configModel.getAllParameterModels().get(0);
        DefaultObjectType objectType = (DefaultObjectType)parameterModel.getType();
        MatcherAssert.assertThat(Class.forName(((ClassInformationAnnotation)objectType.getAnnotation(ClassInformationAnnotation.class).get()).getClassname()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(SimplePojoWithTime.class)));
        Map fieldMap = objectType.getFields().stream().collect(Collectors.toMap(f -> f.getKey().getName().getLocalPart(), Function.identity()));
        MatcherAssert.assertThat((Object)((ObjectFieldType)fieldMap.get("dateTime")).getKey().getName().getLocalPart(), (Matcher)CoreMatchers.is((Object)"dateTime"));
        MatcherAssert.assertThat((Object)((ObjectFieldType)fieldMap.get("dateTime")).getValue(), (Matcher)CoreMatchers.instanceOf(DefaultDateTimeType.class));
    }

    @Test
    public void getImportedTypesFromExtensionUsingTheSdkApi() {
        List importedTypes = this.getParser(SimpleExtensionUsingSdkApi.class).getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }

    @Test
    public void getImportedTypesFromExtensionUsingTheLegacyApi() {
        List importedTypes = this.getParser(SimpleExtensionUsingLegacyApi.class).getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }

    @Test
    public void getImportedTypesFromExtensionUsingBothTheLegacyAndTheSdkApi() {
        List importedTypes = this.getParser(SimpleMixedApiExtension.class).getImportedTypes();
        MatcherAssert.assertThat((Object)importedTypes.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(1)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((MetadataType)importedTypes.get(0)).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)"org.mule.test.vegan.extension.VeganCookBook"));
    }

    @Test
    @Ignore(value="W-12947325")
    public void getExportedTypesFromExtensionUsingTheSdkApi() {
        List exportedTypes = this.getParser(SimpleExtensionUsingSdkApi.class).getPrivilegedExportedPackages();
        MatcherAssert.assertThat((Object)exportedTypes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void getSubtypesFromExtensionWithDuplicatedBaseTypes() {
        Map subTypes = this.getParser(SubTypesDuplication.class).getSubTypes();
        MatcherAssert.assertThat((Object)subTypes.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((List)subTypes.values().iterator().next()), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void getMMVForLegacyExtension() {
        JavaExtensionModelParser parser = this.getParser(ExtensionUsingLegacyApi.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension SimpleExtension has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForSdkExtension() {
        JavaExtensionModelParser parser = this.getParser(ExtensionUsingSdkApi.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension SimpleExtension has min mule version 4.5.0 because it if annotated with the new sdk api @Extension."));
    }

    @Test
    public void getMMVForExtensionWithSuperExtension() {
        JavaExtensionModelParser parser = this.getParser(ExtensionWithSuperExtension.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension ExtensionWithSuperExtension has min mule version 4.4 because of its super class ParameterizedExtension. Extension ParameterizedExtension has min mule version 4.4 because of its field extensionParameter. Field extensionParameter has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForParameterizedExtension() {
        JavaExtensionModelParser parser = this.getParser(ParameterizedExtension.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension MixedConfigurationsAnnotationExtension has min mule version 4.4 because of its field extensionParameter. Field extensionParameter has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForExtensionWithConfiguration() {
        JavaExtensionModelParser parser = this.getParser(ExtensionWithConfiguration.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)ResolvedMinMuleVersion.FIRST_MULE_VERSION));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension MixedConfigurationsAnnotationExtension has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForExtensionAnnotatedWithMMV() {
        JavaExtensionModelParser parser = this.getParser(ExtensionAnnotatedWithMMV.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Calculated Min Mule Version is 4.4 which is greater than the one set at the extension class level 4.3. Overriding it. Extension ExtensionAnnotatedWithMMV has min mule version 4.4 because of its method extensionMethod. Method extensionMethod has min mule version 4.4 because it is the one set at the method level through the @MinMuleVersion annotation."));
    }

    @Test
    public void getMMVForExtensionAnnotatedWithHighMMV() {
        JavaExtensionModelParser parser = this.getParser(ExtensionAnnotatedWithHighMMV.class);
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.7"));
        MatcherAssert.assertThat((Object)((ResolvedMinMuleVersion)parser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Extension ExtensionAnnotatedWithHighMMV has min mule version 4.7 because it is the one set at the class level through the @MinMuleVersion annotation."));
    }

    protected JavaExtensionModelParser getParser(Class<?> extensionClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionTypeWrapper = new ExtensionTypeWrapper(extensionClass, typeLoader);
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        return new JavaExtensionModelParser((ExtensionElement)extensionTypeWrapper, (ExtensionLoadingContext)ctx);
    }

    private static class SimplePojoWithTime {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private String name;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private Integer age;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private LocalDateTime dateTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimplePojoWithTime that = (SimplePojoWithTime)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.age, that.age) && Objects.equals(this.dateTime, that.dateTime);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.age, this.dateTime);
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="ExtensionAnnotatedWithHighMMV")
    @MinMuleVersion(value="4.7")
    private static class ExtensionAnnotatedWithHighMMV {
        @Parameter
        String extensionParameter;

        private ExtensionAnnotatedWithHighMMV() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="ExtensionAnnotatedWithMMV")
    @MinMuleVersion(value="4.3")
    private static class ExtensionAnnotatedWithMMV {
        private ExtensionAnnotatedWithMMV() {
        }

        @MinMuleVersion(value="4.4")
        public void extensionMethod() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="ExtensionWithSuperExtension")
    private static class ExtensionWithSuperExtension
    extends ParameterizedExtension {
        private ExtensionWithSuperExtension() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="MixedConfigurationsAnnotationExtension")
    public static class ParameterizedWithJavaTypeExtension {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private SimplePojoWithTime simplePojoWithTime;

        public ParameterizedWithJavaTypeExtension() {
            this.simplePojoWithTime = this.simplePojoWithTime;
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="MixedConfigurationsAnnotationExtension")
    private static class ParameterizedExtension {
        @Parameter
        String extensionParameter;

        private ParameterizedExtension() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="MixedConfigurationsAnnotationExtension")
    @Configurations(value={ImplementationOne.class})
    private static class ExtensionWithConfiguration {
        Literal<String> extensionField;

        private ExtensionWithConfiguration() {
        }
    }

    private static class ImplementationTwo
    implements BaseInterface {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private String parameterTwo;

        private ImplementationTwo() {
        }
    }

    private static class ImplementationOne
    implements BaseInterface {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private String parameterOne;

        private ImplementationOne() {
        }
    }

    private static interface BaseInterface {
    }

    @Extension(name="SubTypesDuplication")
    @SubTypeMapping(baseType=BaseInterface.class, subTypes={ImplementationOne.class, ImplementationTwo.class, ImplementationOne.class})
    private static class SubTypesDuplication {
        private SubTypesDuplication() {
        }
    }

    @Extension(name="SimpleExtension")
    @org.mule.sdk.api.annotation.Import(type=KnockeableDoor.class)
    @Import(type=VeganCookBook.class)
    private static class SimpleMixedApiExtension {
        private SimpleMixedApiExtension() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="SimpleExtension")
    public static class ExtensionUsingLegacyApi {
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="SimpleExtension")
    @Import(type=KnockeableDoor.class)
    @org.mule.runtime.extension.api.annotation.PrivilegedExport(packages={"org.mule.runtime.module.extension.internal.loader.parser.java"})
    private static class SimpleExtensionUsingLegacyApi {
        private SimpleExtensionUsingLegacyApi() {
        }
    }

    @Extension(name="SimpleExtension")
    public static class ExtensionUsingSdkApi {
    }

    @Extension(name="SimpleExtension")
    @org.mule.sdk.api.annotation.Import(type=KnockeableDoor.class)
    @PrivilegedExport(packages={"org.mule.runtime.module.extension.internal.loader.parser.java"})
    private static class SimpleExtensionUsingSdkApi {
        private SimpleExtensionUsingSdkApi() {
        }
    }
}

