/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.JavaConfigurationModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class JavaConfigurationModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtensionModelValidator validator = new JavaConfigurationModelValidator();

    @Test
    public void validConfigurationTypesForOperations() throws Exception {
        this.validate(ValidExtension.class);
    }

    @Test
    public void invalidConfigurationTypesForOperations() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("requires a configuration of type");
        this.validate(InvalidExtension.class);
    }

    @Test
    public void invalidConfigurationWithInvalidParameter() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Configuration 'configWithParameterWithNameNamedName' declares a parameter whose name is 'name', which is not allowed.");
        this.validate(ConfigNoNameExtension.class);
    }

    private void validate(Class<?> connectorClass) {
        ExtensionsTestUtils.validate(connectorClass, this.validator);
    }

    public static class InvalidTestOperations {
        public void foo(@Config ConfigInterface config) {
        }

        public void bar(@Config Apple config) {
        }
    }

    public static class ValidTestOperations {
        public void foo(@Config ConfigInterface connection) {
        }

        public void bar(@Config ConfigInterface connection) {
        }
    }

    @Operations(value={InvalidTestOperations.class})
    public static class InvalidTestConfig
    implements ConfigInterface {
    }

    @Configuration(name="configWithParameterWithNameNamedName")
    public static class ConfigWithNameParameter
    implements ConfigInterface {
        @Parameter
        private String name;
    }

    @Configuration(name="config2")
    @Operations(value={ValidTestOperations.class})
    public static class TestConfig2
    implements ConfigInterface {
    }

    @Configuration(name="config")
    @Operations(value={ValidTestOperations.class})
    public static class TestConfig
    implements ConfigInterface {
    }

    @Extension(name="validExtension")
    @Configurations(value={TestConfig.class, TestConfig2.class})
    public static class ValidExtension {
    }

    @Extension(name="invalidExtension")
    @Configurations(value={ConfigWithNameParameter.class})
    public static class ConfigNoNameExtension {
    }

    @Extension(name="invalidExtension")
    @Configurations(value={InvalidTestConfig.class})
    public static class InvalidExtension {
    }

    static interface ConfigInterface {
    }
}

