/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ConnectionProviderNameModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionProviderNameModelValidatorTestCase
extends AbstractMuleTestCase {
    private static final String CUSTOM_NAME = "my name";
    private static final String EXTENSION_NAME = "my extension";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    private ConnectionProviderNameModelValidator validator = new ConnectionProviderNameModelValidator();

    private List<ConnectionProviderModel> mockConnectionProviders(String ... names) {
        return Stream.of(names).map(name -> {
            ConnectionProviderModel mock = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)mock.getName()).thenReturn(name);
            return mock;
        }).collect(Collectors.toList());
    }

    @Test
    public void valid() {
        List<ConnectionProviderModel> mockModels = this.mockConnectionProviders("connection", CUSTOM_NAME);
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(mockModels);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalid() {
        List<ConnectionProviderModel> mockModels = this.mockConnectionProviders("connection", "connection", CUSTOM_NAME, CUSTOM_NAME, "bleh");
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(mockModels);
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"4"));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void noConnectionProviders() {
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(Collections.emptyList());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

