/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.info.ExtensionInfo;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.sdk.api.annotation.Extension;
import org.mule.test.module.extension.internal.util.extension.SimpleExportedType;
import org.mule.test.module.extension.internal.util.extension.SimpleExtensionUsingLegacyApi;
import org.mule.test.module.extension.internal.util.extension.SimpleExtensionUsingSdkApi;

public class MuleExtensionAnnotationParserTestCase {
    private static final String LEGACY_EXTENSION_NAME = "legacyExtensionName";
    private static final String SDK_EXTENSION_NAME = "sdkExtensionName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getExtensionInfoFromExtensionUsingTheSdkApi() {
        ExtensionInfo extensionInfo = MuleExtensionAnnotationParser.getExtensionInfo(SimpleExtensionUsingSdkApi.class);
        MatcherAssert.assertThat((Object)extensionInfo.getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension"));
        MatcherAssert.assertThat((Object)extensionInfo.getVendor(), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)extensionInfo.getCategory(), (Matcher)CoreMatchers.equalTo((Object)Category.COMMUNITY));
    }

    @Test
    public void getExtensionInfoFromExtensionUsingTheLegacyApi() {
        ExtensionInfo extensionInfo = MuleExtensionAnnotationParser.getExtensionInfo(SimpleExtensionUsingLegacyApi.class);
        MatcherAssert.assertThat((Object)extensionInfo.getName(), (Matcher)CoreMatchers.is((Object)"SimpleExtension"));
        MatcherAssert.assertThat((Object)extensionInfo.getVendor(), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)extensionInfo.getCategory(), (Matcher)CoreMatchers.equalTo((Object)Category.COMMUNITY));
    }

    @Test
    public void getExtensionInfoFromExtensionNotUsingTheExtensionAnnotation() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Class 'org.mule.test.module.extension.internal.util.extension.SimpleExportedType' not annotated with neither 'org.mule.runtime.extension.api.annotation.Extension' nor 'org.mule.sdk.api.annotation.Extension'"));
        MuleExtensionAnnotationParser.getExtensionInfo(SimpleExportedType.class);
    }

    @Test
    public void mapReduceAnnotationInHierarchy() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        String extensionName = MuleExtensionAnnotationParser.mapReduceAnnotation((WithAnnotations)new TypeWrapper(AnnotatedClass.class, typeLoader), org.mule.runtime.extension.api.annotation.Extension.class, Extension.class, ann -> ann.getStringValue(org.mule.runtime.extension.api.annotation.Extension::name), ann -> ann.getStringValue(Extension::name), () -> new IllegalModelDefinitionException("oops")).orElse(null);
        MatcherAssert.assertThat((Object)extensionName, (Matcher)CoreMatchers.equalTo((Object)SDK_EXTENSION_NAME));
        extensionName = MuleExtensionAnnotationParser.mapReduceAnnotation((WithAnnotations)new TypeWrapper(LegacyAnnotatedClass.class, typeLoader), org.mule.runtime.extension.api.annotation.Extension.class, Extension.class, ann -> ann.getStringValue(org.mule.runtime.extension.api.annotation.Extension::name), ann -> ann.getStringValue(Extension::name), () -> new IllegalModelDefinitionException("oops")).orElse(null);
        MatcherAssert.assertThat((Object)extensionName, (Matcher)CoreMatchers.equalTo((Object)LEGACY_EXTENSION_NAME));
    }

    private static class LegacyAnnotatedClass
    extends LegacyBaseAnnotatedClass {
        private LegacyAnnotatedClass() {
        }
    }

    private static class AnnotatedClass
    extends BaseAnnotatedClass {
        private AnnotatedClass() {
        }
    }

    @Extension(name="legacyExtensionName")
    private static class LegacyBaseAnnotatedClass {
        private LegacyBaseAnnotatedClass() {
        }
    }

    @Extension(name="sdkExtensionName")
    private static class BaseAnnotatedClass {
        private BaseAnnotatedClass() {
        }
    }
}

