/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.test.provided.dependency.ProvidedDependencyExtension;

@Feature(value="SDK")
@Story(value="Min Mule Version calculation")
@Issue(value="W-14645134")
public class ExtensionWithProvidedDependencyTestCase {
    @Test
    @Description(value="Tests that a component that internally relies on a class from a provided dependency doesn't break MMV resolution due to the dependency not being available at design time")
    public void extensionWithParametersRelyingOnProvidedDependencyTypesIsLoaded() {
        ExtensionModel extension = MuleExtensionUtils.loadExtension(ProvidedDependencyExtension.class);
        Assert.assertThat((Object)extension.getName(), (Matcher)CoreMatchers.is((Object)"Provided Dependency"));
        Assert.assertThat((Object)extension.getMinMuleVersion().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((MuleVersion)extension.getMinMuleVersion().get()).toString(), (Matcher)CoreMatchers.is((Object)"4.1.1"));
        Assert.assertThat((Object)extension.getConfigurationModel("config").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ConfigurationModel configurationModel = (ConfigurationModel)extension.getConfigurationModel("config").get();
        OperationModel operationModel = (OperationModel)configurationModel.getOperationModel("dummyOperation").orElseThrow(() -> new RuntimeException("'dummyOperation' not found"));
        Assert.assertThat((Object)operationModel.getMinMuleVersion().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((MuleVersion)operationModel.getMinMuleVersion().get()).toString(), (Matcher)CoreMatchers.is((Object)"4.1.1"));
    }
}

