/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.config.builders.MinimalConfigurationBuilder;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.TestTimeSupplier;

@SmallTest
@Feature(value="Java SDK")
@Story(value="Connectivity test")
public class AsyncTestConnectivityTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    protected static final int RECONNECTION_MAX_ATTEMPTS = 5;
    private static final int RECONNECTION_FREQ = 100;
    private static final String NAME = "name";
    private static final int TEST_TIMEOUT = 2000;
    private static final int TEST_POLL_DELAY = 10;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private ConfigurationState configurationState;
    protected Lifecycle value = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
    protected AsyncConnectionManagerAdapter connectionManager;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected LifecycleAwareConfigurationInstance configurationInstance;
    private final TestTimeSupplier timeSupplier = new TestTimeSupplier(System.currentTimeMillis());
    private final Optional<ConnectionProvider> connectionProvider = Optional.of((ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class, MuleContextAware.class})));

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleTimeSupplier", this.timeSupplier);
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new MinimalConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                super.doConfigure(muleContext);
                AsyncTestConnectivityTestCase.this.retryPolicyTemplate = AsyncTestConnectivityTestCase.this.createRetryTemplate();
                AsyncTestConnectivityTestCase.this.retryPolicyTemplate.setNotifier((RetryNotifier)Mockito.mock(RetryNotifier.class));
                AsyncTestConnectivityTestCase.this.connectionManager = (AsyncConnectionManagerAdapter)Mockito.spy((Object)new AsyncConnectionManagerAdapter(AsyncTestConnectivityTestCase.this.retryPolicyTemplate));
                this.registerObject("_muleConnectionManager", AsyncTestConnectivityTestCase.this.connectionManager, muleContext);
            }
        };
    }

    protected void doSetUp() throws Exception {
        this.configurationInstance = this.createConfigurationInstance();
        super.doSetUp();
    }

    protected RetryPolicyTemplate createRetryTemplate() {
        return new AsynchronousRetryTemplate((RetryPolicyTemplate)new SimpleRetryPolicyTemplate(100L, 5));
    }

    @After
    public void after() {
        this.configurationInstance.dispose();
    }

    protected LifecycleAwareConfigurationInstance createConfigurationInstance() throws MuleException {
        return (LifecycleAwareConfigurationInstance)muleContext.getInjector().inject((Object)new LifecycleAwareConfigurationInstance(NAME, this.configurationModel, (Object)this.value, this.configurationState, this.connectionProvider));
    }

    @Test
    @Description(value="Checks that the test connectivity test is not interrupted")
    public void testConnectivityIsNotInterruptedWhenAsyncRetryTemplate() throws Exception {
        this.configurationInstance.initialise();
        this.configurationInstance.start();
        new PollingProber(2000L, 10L).check((Probe)new JUnitLambdaProbe(() -> {
            ((AsyncConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).testConnectivity((ConfigurationInstance)this.configurationInstance);
            Assert.assertThat((Object)this.connectionManager.wasInterruptedBeforeTestingConnectivity(), (Matcher)Matchers.is((Object)false));
            return true;
        }));
    }

    private static class AsyncConnectionManagerAdapter
    implements ConnectionManagerAdapter {
        private final RetryPolicyTemplate retryPolicyTemplate;
        private boolean interrupted = false;

        public AsyncConnectionManagerAdapter(RetryPolicyTemplate retryPolicyTemplate) {
            this.retryPolicyTemplate = retryPolicyTemplate;
        }

        public <C> void bind(Object config, ConnectionProvider<C> connectionProvider) {
        }

        public boolean hasBinding(Object config) {
            return false;
        }

        public void unbind(Object config) {
        }

        public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
            return null;
        }

        public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
            if (Thread.currentThread().isInterrupted()) {
                this.interrupted = true;
            }
            return ConnectionValidationResult.success();
        }

        public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
            return ConnectionValidationResult.success();
        }

        public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
            return ConnectionValidationResult.success();
        }

        public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance, boolean force) throws IllegalArgumentException {
            return ConnectionValidationResult.success();
        }

        public void initialise() throws InitialisationException {
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }

        public void dispose() {
        }

        public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
            return this.retryPolicyTemplate;
        }

        public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
            return null;
        }

        public PoolingProfile getDefaultPoolingProfile() {
            return null;
        }

        public boolean wasInterruptedBeforeTestingConnectivity() {
            return this.interrupted;
        }
    }
}

