/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.data.sample;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.data.sample.ComponentSampleDataProvider;
import org.mule.runtime.module.extension.internal.data.sample.MuleSampleDataService;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataTestUtils;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="SDK Tooling Support")
@Story(value="Sample Data Service")
public class MuleSampleDataServiceTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private Location location;
    @Mock
    private ConfigurationComponentLocator componentLocator;
    @Mock(extraInterfaces={Component.class})
    private ComponentSampleDataProvider componentSampleDataProvider;
    @Mock
    private Message message;
    private final MuleSampleDataService sampleDataService = new MuleSampleDataService();

    @Before
    public void before() throws SampleDataException {
        this.sampleDataService.setComponentLocator(this.componentLocator);
        Mockito.when((Object)this.componentSampleDataProvider.getSampleData()).thenReturn((Object)this.message);
        Mockito.when((Object)this.componentLocator.find(this.location)).thenReturn(Optional.of((Component)this.componentSampleDataProvider));
    }

    @Test
    public void getSampleData() throws SampleDataException {
        Assert.assertThat((Object)this.sampleDataService.getSampleData(this.location), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.message)));
        ((ComponentSampleDataProvider)Mockito.verify((Object)this.componentSampleDataProvider)).getSampleData();
    }

    @Test
    public void noDataFound() throws SampleDataException {
        this.expectSampleDataException("NO_DATA_AVAILABLE");
        Mockito.when((Object)this.componentSampleDataProvider.getSampleData()).thenReturn(null);
        this.sampleDataService.getSampleData(this.location);
    }

    @Test
    public void invalidLocation() throws SampleDataException {
        this.expectSampleDataException("INVALID_LOCATION");
        Mockito.when((Object)this.componentLocator.find(this.location)).thenReturn(Optional.empty());
        this.sampleDataService.getSampleData(this.location);
    }

    @Test
    public void resolutionException() throws SampleDataException {
        SampleDataException e = new SampleDataException("some message", "UNKNOWN");
        this.expectedException.expect(CoreMatchers.sameInstance((Object)e));
        Mockito.when((Object)this.componentSampleDataProvider.getSampleData()).thenThrow(new Throwable[]{e});
        this.sampleDataService.getSampleData(this.location);
    }

    @Test
    public void unsupportedComponent() throws SampleDataException {
        Mockito.when((Object)this.componentLocator.find(this.location)).thenReturn(Optional.of((Component)Mockito.mock(Component.class)));
        this.expectSampleDataException("NOT_SUPPORTED");
        this.sampleDataService.getSampleData(this.location);
    }

    private void expectSampleDataException(String failureCode) {
        this.expectedException.expect(SampleDataException.class);
        this.expectedException.expect(SampleDataTestUtils.exceptionMatcher(failureCode));
    }
}

