/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConfig;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuthHandlerTestCase
extends AbstractMuleContextTestCase {
    private static final String SOME_KEY = "1874947571-1840879217-380895431-1745289126";
    private static final String OTHER_KEY = "1874947571-1840879217-123123123-1745289126";
    private static final List<String> OBJECT_STORE_ENTRIES = Arrays.asList("1874947571-1840879217-380895431-1745289126", "1874947571-1840879217-123123123-1745289126");
    @InjectMocks
    AuthorizationCodeOAuthHandler oauthHandler = new AuthorizationCodeOAuthHandler();
    @Mock
    private ObjectStoreManager storeManager;
    @Mock
    private ObjectStore<MetadataCache> objectStore;
    private ConfigurationProperties configurationProperties;
    private static final String CLIENT_ID = "client_id";
    private static final String SECRET_ID = "secret_id";
    private static final String ORG_ID = "org_id";
    private static final String SERVICE_URL = "service_url";
    private static final String PLATFORM_AUTH_URL = "http://localhost/accounts";
    @Rule
    public TemporaryFolder tempWorkDir = new TemporaryFolder();

    @Test
    @Issue(value="W-11410770")
    @Description(value="Verify that ObjectStore is created, if none exists by calling getOrCreateObjectStore")
    public void verifyThatObjectStoreisAlwaysCreated() throws InitialisationException, ObjectStoreException {
        PlatformManagedOAuthConfig config = PlatformManagedOAuthConfig.from((String)"", (String)"", null, null, null, null, (ConfigurationProperties)this.configurationProperties);
        this.oauthHandler.initialise();
        ObjectStore objectStore = (ObjectStore)this.oauthHandler.getObjectStoreLocator().apply(config);
        MatcherAssert.assertThat((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)objectStore.allKeys(), (Matcher)CoreMatchers.is(OBJECT_STORE_ENTRIES));
        ((ObjectStoreManager)Mockito.verify((Object)this.storeManager, (VerificationMode)Mockito.times((int)1))).getOrCreateObjectStore(ArgumentMatchers.anyString(), (ObjectStoreSettings)ArgumentMatchers.any(ObjectStoreSettings.class));
    }

    @Before
    public void setup() throws ObjectStoreException {
        Mockito.when((Object)this.storeManager.getOrCreateObjectStore(ArgumentMatchers.anyString(), (ObjectStoreSettings)ArgumentMatchers.any())).thenReturn(this.objectStore);
        Mockito.when((Object)this.objectStore.allKeys()).thenReturn(Arrays.asList(SOME_KEY, OTHER_KEY));
        this.configurationProperties = (ConfigurationProperties)Mockito.mock(ConfigurationProperties.class);
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.client.secret")).thenReturn(Optional.of(SECRET_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.client.id")).thenReturn(Optional.of(CLIENT_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("csorganization.id")).thenReturn(Optional.of(ORG_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.url")).thenReturn(Optional.of(SERVICE_URL));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.platform.authentication.url")).thenReturn(Optional.of(PLATFORM_AUTH_URL));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.api.version")).thenReturn(Optional.empty());
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.api.version")).thenReturn(Optional.empty());
    }

    protected void doTearDown() throws Exception {
        this.oauthHandler.stop();
    }
}

