/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.validator.TransactionalParametersValidator;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class TransactionalParametersValidatorTestCase {
    private final Optional<TransactionalActionModelProperty> transactionalActionModelProperty = Optional.of(new TransactionalActionModelProperty());
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ExtensionModel extensionModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    OperationModel operationModel;
    @Mock
    ParameterGroupModel parameterGroupModel;
    @Mock
    ParameterModel txParameter;
    ExtensionModelValidator validator = new TransactionalParametersValidator();
    private ProblemsReporter problemsReporter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getParameterGroupModels()).thenReturn(Collections.singletonList(this.parameterGroupModel));
        Mockito.when((Object)this.sourceModel.isTransactional()).thenReturn((Object)true);
        Mockito.when((Object)this.operationModel.isTransactional()).thenReturn((Object)true);
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Collections.singletonList(this.txParameter));
        Mockito.when((Object)this.txParameter.getName()).thenReturn((Object)"transactionalAction");
        Mockito.when((Object)this.txParameter.getModelProperty(TransactionalActionModelProperty.class)).thenReturn(this.transactionalActionModelProperty);
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
    }

    @Test
    public void transactionalActionIsReservedWord() {
        Mockito.when((Object)this.txParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Problem problem = (Problem)errors.get(0);
        MatcherAssert.assertThat((Object)problem.getComponent(), (Matcher)CoreMatchers.is((Object)this.sourceModel));
        MatcherAssert.assertThat((Object)problem.getMessage(), (Matcher)CoreMatchers.containsString((String)"defines a parameter named: 'transactionalAction', which is a reserved word"));
    }

    @Test
    public void transactionalParameterWithReservedWord() {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void transactionalParameterCantBePlacedInParameterGroupWithShowInDsl() {
        Mockito.when((Object)this.parameterGroupModel.isShowInDsl()).thenReturn((Object)true);
        this.validator.validate(this.extensionModel, this.problemsReporter);
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Problem problem = (Problem)errors.get(0);
        MatcherAssert.assertThat((Object)problem.getComponent(), (Matcher)CoreMatchers.is((Object)this.sourceModel));
        MatcherAssert.assertThat((Object)problem.getMessage(), (Matcher)CoreMatchers.containsString((String)"Transactional parameters can't be placed inside of Parameter Groups with 'showInDsl' option."));
    }
}

