/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.TargetParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

@RunWith(value=Parameterized.class)
public class TargetParameterDeclarationEnricherTestCase {
    public static final String PAYLOAD_EXPRESSION = "#[payload]";
    public static final String TEST_VALUE = "testValue";
    public static final String TEST_EXPRESSION = "#[testExpression]";
    private ExtensionDeclarer extensionDeclarer;
    private final ParameterGroupDeclaration parameterGroupDeclaration;
    private final boolean isEmptyOutputParameterGroup;

    @Parameterized.Parameters
    public static Collection<ParameterGroupDeclaration> getParameters() {
        return Arrays.asList(TargetParameterDeclarationEnricherTestCase.getOutputParameterGroupDeclarationStub(), new ParameterGroupDeclaration("Output"));
    }

    public TargetParameterDeclarationEnricherTestCase(ParameterGroupDeclaration parameterGroupDeclaration) {
        this.parameterGroupDeclaration = parameterGroupDeclaration;
        this.isEmptyOutputParameterGroup = parameterGroupDeclaration.getParameters().isEmpty();
    }

    @Before
    public void setUp() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)Mockito.mock(OperationDeclaration.class);
        OutputDeclaration outputDeclaration = (OutputDeclaration)Mockito.mock(OutputDeclaration.class);
        Mockito.when((Object)outputDeclaration.getType()).thenReturn((Object)((MetadataType)Mockito.mock(StringType.class)));
        Mockito.when((Object)operationDeclaration.getOutput()).thenReturn((Object)outputDeclaration);
        Mockito.when((Object)operationDeclaration.getName()).thenReturn((Object)"mockedOperation");
        Mockito.when((Object)operationDeclaration.getParameterGroup("Output")).thenReturn((Object)this.parameterGroupDeclaration);
        OperationDeclarer operationDeclarer = (OperationDeclarer)Mockito.mock(OperationDeclarer.class);
        Mockito.when((Object)((OperationDeclaration)operationDeclarer.getDeclaration())).thenReturn((Object)operationDeclaration);
        this.extensionDeclarer = new ExtensionDeclarer().named("mockedExtension");
        this.extensionDeclarer.withOperation(operationDeclarer);
    }

    private static ParameterGroupDeclaration getOutputParameterGroupDeclarationStub() {
        ParameterGroupDeclaration parameterGroupDeclarationStub = new ParameterGroupDeclaration("Output");
        ParameterDeclaration targetParameterDeclarationStub = new ParameterDeclaration("target");
        targetParameterDeclarationStub.setDefaultValue((Object)TEST_VALUE);
        targetParameterDeclarationStub.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        targetParameterDeclarationStub.setType((MetadataType)Mockito.mock(StringType.class), false);
        targetParameterDeclarationStub.setRequired(false);
        parameterGroupDeclarationStub.addParameter(targetParameterDeclarationStub);
        ParameterDeclaration targetValueParameterDeclarationStub = new ParameterDeclaration("targetValue");
        targetValueParameterDeclarationStub.setRequired(false);
        targetValueParameterDeclarationStub.setExpressionSupport(ExpressionSupport.REQUIRED);
        targetValueParameterDeclarationStub.setType((MetadataType)Mockito.mock(StringType.class), false);
        targetValueParameterDeclarationStub.setDefaultValue((Object)TEST_EXPRESSION);
        parameterGroupDeclarationStub.addParameter(targetValueParameterDeclarationStub);
        return parameterGroupDeclarationStub;
    }

    @Test
    public void verifyOperationEnrichment() {
        new TargetParameterDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.extensionDeclarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        MatcherAssert.assertThat((Object)this.parameterGroupDeclaration.getName(), (Matcher)Matchers.is((Object)"Output"));
        this.assertTargetParameterEnrichment();
        this.assertTargetValueEnrichment();
    }

    private void assertTargetParameterEnrichment() {
        ParameterDeclaration targetParameterDeclaration = (ParameterDeclaration)MuleExtensionUtils.getNamedObject((List)this.parameterGroupDeclaration.getParameters(), (String)"target");
        MatcherAssert.assertThat((Object)targetParameterDeclaration.getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)targetParameterDeclaration.isRequired(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)targetParameterDeclaration.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        if (this.isEmptyOutputParameterGroup) {
            MatcherAssert.assertThat((Object)targetParameterDeclaration.getDefaultValue(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)targetParameterDeclaration.getDefaultValue(), (Matcher)Matchers.is((Object)TEST_VALUE));
        }
    }

    private void assertTargetValueEnrichment() {
        ParameterDeclaration targetParameterDeclaration = (ParameterDeclaration)MuleExtensionUtils.getNamedObject((List)this.parameterGroupDeclaration.getParameters(), (String)"targetValue");
        MatcherAssert.assertThat((Object)targetParameterDeclaration.getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)targetParameterDeclaration.isRequired(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)targetParameterDeclaration.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.REQUIRED));
        if (this.isEmptyOutputParameterGroup) {
            MatcherAssert.assertThat((Object)targetParameterDeclaration.getDefaultValue(), (Matcher)Matchers.is((Object)PAYLOAD_EXPRESSION));
        } else {
            MatcherAssert.assertThat((Object)targetParameterDeclaration.getDefaultValue(), (Matcher)Matchers.is((Object)TEST_EXPRESSION));
        }
    }
}

