/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="SDK")
public class MuleExtensionUtilsTestCase
extends AbstractMuleTestCase {
    private static final String PAYLOAD_EXPRESSION = "#[payload]";
    private static final String MALFORMED_EXPRESSION = "#[payload";
    private static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Description(value="Parse mule expression")
    public void extractMuleExpression() {
        java.util.Optional expressionValue = MuleExtensionUtils.extractExpression((Object)PAYLOAD_EXPRESSION);
        Assert.assertThat((Object)expressionValue, (Matcher)CoreMatchers.is(java.util.Optional.of("payload")));
    }

    @Test
    @Description(value="Try parse malformed mule expression")
    public void parseMalformedMuleExpression() {
        java.util.Optional expressionValue = MuleExtensionUtils.extractExpression((Object)MALFORMED_EXPRESSION);
        Assert.assertThat((Object)expressionValue, (Matcher)CoreMatchers.is(java.util.Optional.empty()));
    }

    @Test
    public void deprecatedOptionalWithDefaultValue() {
        org.mule.runtime.extension.api.annotation.param.Optional optional = (org.mule.runtime.extension.api.annotation.param.Optional)Mockito.mock(org.mule.runtime.extension.api.annotation.param.Optional.class);
        Mockito.when((Object)optional.defaultValue()).thenReturn((Object)DEFAULT_VALUE);
        this.assertOptional(MuleExtensionUtils.getDefaultValue((org.mule.runtime.extension.api.annotation.param.Optional)optional));
    }

    @Test
    public void optionalWithDefaultValue() {
        Optional optional = (Optional)Mockito.mock(Optional.class);
        Mockito.when((Object)optional.defaultValue()).thenReturn((Object)DEFAULT_VALUE);
        this.assertOptional(MuleExtensionUtils.getDefaultValue((Optional)optional));
    }

    @Test
    public void parameterGroupExclusivenessForDslTrueSomeParameter() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> someParameterResolvers = new HashMap<String, ValueResolver>();
        someParameterResolvers.put("someParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver someParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)someParameter.getParameters()).thenReturn(someParameterResolvers);
        HashMap<String, ObjectBuilderValueResolver> parameters = new HashMap<String, ObjectBuilderValueResolver>();
        parameters.put("oneParameterGroup", someParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(true), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessForDslTrueRepeatedNameParameter() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> repeatedNameParameterResolvers = new HashMap<String, ValueResolver>();
        repeatedNameParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver repeatedNameParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)repeatedNameParameter.getParameters()).thenReturn(repeatedNameParameterResolvers);
        HashMap<String, ValueResolver> pojoParameterResolvers = new HashMap<String, ValueResolver>();
        pojoParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        pojoParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver pojoParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)pojoParameter.getParameters()).thenReturn(pojoParameterResolvers);
        HashMap<String, ObjectBuilderValueResolver> parameters = new HashMap<String, ObjectBuilderValueResolver>();
        parameters.put("pojoParameter", pojoParameter);
        parameters.put("oneParameterGroup", repeatedNameParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(true), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseSomeParameter() throws ConfigurationException {
        HashMap<String, StaticValueResolver> parameters = new HashMap<String, StaticValueResolver>();
        parameters.put("someParameter", (StaticValueResolver)Mockito.mock(StaticValueResolver.class));
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseComplexParameterDynamic() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> complexParameterResolvers = new HashMap<String, ValueResolver>();
        complexParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        complexParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver complexParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)complexParameter.getParameters()).thenReturn(complexParameterResolvers);
        HashMap<String, ObjectBuilderValueResolver> parameters = new HashMap<String, ObjectBuilderValueResolver>();
        parameters.put("complexParameter", complexParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseRepeatedNameParameter() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> pojoParameterResolvers = new HashMap<String, ValueResolver>();
        pojoParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        pojoParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver pojoParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)pojoParameter.getParameters()).thenReturn(pojoParameterResolvers);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        parameters.put("pojoParameter", pojoParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessDslFalseComplexParameterDynamicAndPojoParameter() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> pojoParameterResolvers = new HashMap<String, ValueResolver>();
        pojoParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        pojoParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver pojoParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)pojoParameter.getParameters()).thenReturn(pojoParameterResolvers);
        HashMap<String, ObjectBuilderValueResolver> parameters = new HashMap<String, ObjectBuilderValueResolver>();
        parameters.put("pojoParameter", pojoParameter);
        parameters.put("complexParameter", pojoParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), parameters, Collections.emptyMap());
    }

    @Test
    public void parameterGroupNameMissingAmongResolvedParameterNamesWithDslTrue() throws ConfigurationException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Was expecting a parameter with name [oneParameterGroup] among the resolved parameters");
        HashMap<String, StaticValueResolver> parameters = new HashMap<String, StaticValueResolver>();
        parameters.put("someParameter", (StaticValueResolver)Mockito.mock(StaticValueResolver.class));
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(true), parameters, Collections.emptyMap());
    }

    @Test
    public void moreThanOneParameterSetInGroup() throws ConfigurationException, ValueResolvingException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("In operation 'null', the following parameters cannot be set at the same time: [someParameter, complexParameter]");
        HashMap<String, StaticValueResolver> parameters = new HashMap<String, StaticValueResolver>();
        parameters.put("someParameter", (StaticValueResolver)Mockito.mock(StaticValueResolver.class));
        parameters.put("complexParameter", (StaticValueResolver)Mockito.mock(StaticValueResolver.class));
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), parameters, Collections.emptyMap());
    }

    @Test
    public void noParametersSetInGroup() throws ConfigurationException, ValueResolvingException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Parameter group 'null' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [someParameter, repeatedNameParameter, complexParameter]");
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModels(false), Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseWithSimpleParameterWithAlias() throws ConfigurationException, ValueResolvingException {
        HashMap<String, StaticValueResolver> parameters = new HashMap<String, StaticValueResolver>();
        parameters.put("some-parameter-alias", (StaticValueResolver)Mockito.mock(StaticValueResolver.class));
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModelsWithAlias(false), parameters, this.getAliasedParameters());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseWithComplexParameterWithAlias() throws ConfigurationException, ValueResolvingException {
        HashMap<String, ValueResolver> pojoParameterResolvers = new HashMap<String, ValueResolver>();
        pojoParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        pojoParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver pojoParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)pojoParameter.getParameters()).thenReturn(pojoParameterResolvers);
        HashMap<String, ObjectBuilderValueResolver> parameters = new HashMap<String, ObjectBuilderValueResolver>();
        parameters.put("complex-parameter-alias", pojoParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModelsWithAlias(false), parameters, this.getAliasedParameters());
    }

    @Test
    public void parameterGroupExclusivenessForDslFalseWithMultipleParametersWithAlias() throws ConfigurationException, ValueResolvingException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("In operation 'null', the following parameters cannot be set at the same time: [some-parameter-alias, complex-parameter-alias]");
        HashMap<String, ValueResolver> pojoParameterResolvers = new HashMap<String, ValueResolver>();
        pojoParameterResolvers.put("repeatedNameParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        pojoParameterResolvers.put("anotherParameter", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        ObjectBuilderValueResolver pojoParameter = (ObjectBuilderValueResolver)Mockito.mock(ObjectBuilderValueResolver.class);
        Mockito.when((Object)pojoParameter.getParameters()).thenReturn(pojoParameterResolvers);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("some-parameter-alias", (ValueResolver)Mockito.mock(StaticValueResolver.class));
        parameters.put("complex-parameter-alias", pojoParameter);
        MuleExtensionUtils.checkParameterGroupExclusiveness(java.util.Optional.of((ParameterizedModel)Mockito.mock(OperationModel.class)), this.getParameterGroupModelsWithAlias(false), parameters, this.getAliasedParameters());
    }

    @Test
    @Story(value="Supported Java Versions are reflected in the ExtensionModel")
    public void getJavaVersionsIntersection() {
        this.assertJavaVersions(new String[][]{{"1.8", "11", "17"}, {"1.8", "11"}, {"1.8", "11"}}, "1.8", "11");
        this.assertJavaVersions(new String[][]{{"1.8", "11", "17"}, {"1.8", "11", "17"}}, "1.8", "11", "17");
        this.assertJavaVersions(new String[][]{{"1.8", "11", "17"}, {"1.8"}, {"1.8", "11", "17"}}, "1.8");
        this.assertJavaVersions(new String[][]{{"1.8", "11", "17"}}, "1.8", "11", "17");
        this.assertJavaVersions(new String[][]{{"1.8"}, {"11"}, {"17"}}, null);
        this.assertJavaVersions(new String[][]{{"1.8", "11"}, {"1.8", "11", "17"}, {"17"}}, null);
    }

    private void assertJavaVersions(String[][] input, String ... expected) {
        Set resolved = MuleExtensionUtils.getJavaVersionsIntersection(this.mockExtensionModelsWithSupportedJavaVersions(input));
        if (expected != null) {
            Assert.assertThat((Object)resolved.size(), (Matcher)CoreMatchers.equalTo((Object)expected.length));
            Assert.assertThat((Object)resolved, (Matcher)Matchers.contains((Object[])expected));
        } else {
            Assert.assertThat((Object)resolved, (Matcher)Matchers.hasSize((int)0));
        }
    }

    private List<ExtensionModel> mockExtensionModelsWithSupportedJavaVersions(String[][] versions) {
        return Stream.of(versions).map(v -> {
            ExtensionModel model = (ExtensionModel)Mockito.mock(ExtensionModel.class);
            Mockito.when((Object)model.getSupportedJavaVersions()).thenReturn((Object)Stream.of(v).collect(Collectors.toCollection(LinkedHashSet::new)));
            return model;
        }).collect(Collectors.toList());
    }

    private void assertOptional(java.util.Optional<String> defaultValue) {
        Assert.assertThat((Object)defaultValue.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)defaultValue.get(), (Matcher)CoreMatchers.is((Object)DEFAULT_VALUE));
    }

    private Map<String, String> getAliasedParameters() {
        HashMap<String, String> aliasedParameters = new HashMap<String, String>();
        aliasedParameters.put("someParameter", "some-parameter-alias");
        aliasedParameters.put("repeatedNameParameter", "repeated-nameParameter-alias");
        aliasedParameters.put("complexParameter", "complex-parameter-alias");
        return aliasedParameters;
    }

    private List<ParameterGroupModel> getParameterGroupModels(boolean showInDsl) {
        return this.getParameterGroupModels(showInDsl, "someParameter", "repeatedNameParameter", "complexParameter");
    }

    private List<ParameterGroupModel> getParameterGroupModelsWithAlias(boolean showInDsl) {
        return this.getParameterGroupModels(showInDsl, "some-parameter-alias", "repeated-nameParameter-alias", "complex-parameter-alias");
    }

    private List<ParameterGroupModel> getParameterGroupModels(boolean showInDsl, String ... parameters) {
        ExclusiveParametersModel exclusiveParametersModel = (ExclusiveParametersModel)Mockito.mock(ExclusiveParametersModel.class);
        Mockito.when((Object)exclusiveParametersModel.getExclusiveParameterNames()).thenReturn(new HashSet<String>(Arrays.asList(parameters)));
        Mockito.when((Object)exclusiveParametersModel.isOneRequired()).thenReturn((Object)true);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getExclusiveParametersModels()).thenReturn(Collections.singletonList(exclusiveParametersModel));
        Mockito.when((Object)parameterGroupModel.isShowInDsl()).thenReturn((Object)showInDsl);
        ExtensionParameter extensionParameter = (ExtensionParameter)Mockito.mock(ExtensionParameter.class);
        Mockito.when((Object)extensionParameter.getName()).thenReturn((Object)"oneParameterGroup");
        ExtensionParameterDescriptorModelProperty property = (ExtensionParameterDescriptorModelProperty)Mockito.mock(ExtensionParameterDescriptorModelProperty.class);
        Mockito.when((Object)property.getExtensionParameter()).thenReturn((Object)extensionParameter);
        Mockito.when((Object)parameterGroupModel.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).thenReturn(java.util.Optional.of(property));
        return Collections.singletonList(parameterGroupModel);
    }
}

