/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.internal.profiling.NoOpProfilingService;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionSourceBinder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultSourceCallbackContextTestCase
extends AbstractMuleTestCase {
    private ProfilingService profilingService = new NoOpProfilingService();
    @Rule
    public ExpectedException expected = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionReleasedOnTxExceptionNoConnHandler() throws ConnectionException, TransactionException {
        Object conn = Mockito.mock(TransactionalConnection.class);
        SourceCallbackAdapter sourceCallback = (SourceCallbackAdapter)Mockito.mock(SourceCallbackAdapter.class);
        TransactionConfig txConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)txConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)sourceCallback.getTransactionConfig()).thenReturn((Object)txConfig);
        SourceConnectionManager sourceConnMgr = (SourceConnectionManager)Mockito.mock(SourceConnectionManager.class);
        Mockito.when((Object)sourceConnMgr.getConnectionHandler(conn)).thenReturn(Optional.empty());
        Mockito.when((Object)sourceCallback.getSourceConnectionManager()).thenReturn((Object)sourceConnMgr);
        DefaultSourceCallbackContext ctx = new DefaultSourceCallbackContext(sourceCallback, this.profilingService, false);
        this.expected.expect(TransactionException.class);
        try {
            ctx.bindConnection(conn);
        }
        finally {
            ((SourceConnectionManager)Mockito.verify((Object)sourceConnMgr)).release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionReleasedOnTxExceptionOnBindConnToTx() throws ConnectionException, TransactionException {
        Object conn = Mockito.mock(TransactionalConnection.class);
        SourceCallbackAdapter sourceCallback = (SourceCallbackAdapter)Mockito.mock(SourceCallbackAdapter.class);
        TransactionConfig txConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)txConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)sourceCallback.getTransactionConfig()).thenReturn((Object)txConfig);
        SourceConnectionManager sourceConnMgr = (SourceConnectionManager)Mockito.mock(SourceConnectionManager.class);
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)sourceConnMgr.getConnectionHandler(conn)).thenReturn(Optional.of(connectionHandler));
        Mockito.when((Object)sourceCallback.getSourceConnectionManager()).thenReturn((Object)sourceConnMgr);
        TransactionSourceBinder binder = (TransactionSourceBinder)Mockito.mock(TransactionSourceBinder.class);
        Mockito.when((Object)binder.bindToTransaction(txConfig, sourceCallback.getConfigurationInstance(), sourceCallback.getSourceLocation(), connectionHandler, sourceCallback.getTransactionManager(), sourceCallback.getTimeout(), false)).thenThrow(TransactionException.class);
        Mockito.when((Object)sourceCallback.getTransactionSourceBinder()).thenReturn((Object)binder);
        DefaultSourceCallbackContext ctx = new DefaultSourceCallbackContext(sourceCallback, this.profilingService, false);
        this.expected.expect(TransactionException.class);
        try {
            ctx.bindConnection(conn);
        }
        finally {
            ((SourceConnectionManager)Mockito.verify((Object)sourceConnMgr)).release(conn);
        }
    }
}

