/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.executor;

import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutorGenerator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MethodExecutorGeneratorTestCase
extends AbstractMuleContextTestCase {
    private final MethodExecutorGenerator generator = new MethodExecutorGenerator();

    @Before
    public void before() throws InitialisationException {
        this.generator.setContext(muleContext);
    }

    @Test
    public void sameMethodGeneratesUniqueClass() {
        Method method = this.getMethod("sampleOperation");
        MethodExecutor executor1 = this.generator.generate((Object)this, method, this.mockArgumentResolverDelegate(method));
        MethodExecutor executor2 = this.generator.generate((Object)this, method, this.mockArgumentResolverDelegate(method));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)executor2))));
        Assert.assertThat(executor1.getClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(executor2.getClass())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19912")
    public void sameMethodGeneratesUniqueClassConcurrently() throws InterruptedException, ExecutionException {
        Method method = this.getMethod("sampleOperation");
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        try {
            HashSet<Future<MethodExecutor>> results = new HashSet<Future<MethodExecutor>>();
            for (int i = 0; i < 64; ++i) {
                String string = muleContext.getConfiguration().getId() + i;
                results.add(threadPool.submit(() -> {
                    MethodExecutorGenerator generator = new MethodExecutorGenerator();
                    generator.setArtifactId(ctxId);
                    return generator.generate((Object)this, method, this.mockArgumentResolverDelegate(method));
                }));
            }
            for (Future future : results) {
                future.get();
            }
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Test
    public void differentMethodsGenerateDifferentClasses() {
        Method method1 = this.getMethod("sampleOperation");
        Method method2 = this.getMethod("anotherOperation");
        MethodExecutor executor1 = this.generator.generate((Object)this, method1, this.mockArgumentResolverDelegate(method1));
        MethodExecutor executor2 = this.generator.generate((Object)this, method2, this.mockArgumentResolverDelegate(method2));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)executor2))));
        Assert.assertThat(executor1.getClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(executor2.getClass()))));
    }

    private Method getMethod(String methodName) {
        return Stream.of(((Object)((Object)this)).getClass().getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().get();
    }

    public InputStream sampleOperation(@Config MethodExecutorGeneratorTestCase config, String param1, Map<String, Object> map, StreamingHelper streamingHelper) {
        return new ByteArrayInputStream(param1.getBytes());
    }

    public String anotherOperation(@Config MethodExecutorGeneratorTestCase config, int param1) {
        return "" + param1;
    }

    private ArgumentResolverDelegate mockArgumentResolverDelegate(Method method) {
        ArgumentResolverDelegate delegate = (ArgumentResolverDelegate)Mockito.mock(ArgumentResolverDelegate.class);
        ArgumentResolver[] resolvers = new ArgumentResolver[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            resolvers[i] = (ArgumentResolver)Mockito.mock(ArgumentResolver.class);
        }
        Mockito.when((Object)delegate.getArgumentResolvers()).thenReturn((Object)resolvers);
        return delegate;
    }
}

