/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConnectionProviderTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.sdk.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.sdk.api.annotation.connectivity.oauth.OAuthCallbackValue;
import org.mule.sdk.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.CachedConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.connectivity.PoolingConnectionProvider;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.mule.sdk.api.runtime.parameter.Literal;

public class JavaConnectionProviderModelParserTestCase {
    protected JavaConnectionProviderModelParser parser;
    protected ConnectionProviderElement connectionProviderElement;
    private static final String ACCESS_TOKEN_URL = "accessTokenUrl";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String ACCESS_TOKEN_EXPR = "accessTokenExpr";
    private static final String EXPIRATION_EXPR = "expirationExpr";
    private static final String REFRESH_TOKEN_EXPR = "refreshTokenExpr";
    private static final String DEFAULT_SCOPES = "defaultScopes";
    private static final CredentialsPlacement CREDENTIALS_PLACEMENT = CredentialsPlacement.QUERY_PARAMS;
    private static final org.mule.sdk.api.security.CredentialsPlacement SDK_CREDENTIALS_PLACEMENT = org.mule.sdk.api.security.CredentialsPlacement.QUERY_PARAMS;
    private static final boolean INCLUDE_REDIRECT_URI_IN_REFRESH_TOKEN_REQUEST = false;
    private static final String TOKEN_URL = "tokenUrl";
    private static final ValidationOAuthGrantTypeVisitor VALIDATION_O_AUTH_GRANT_TYPE_VISITOR = new ValidationOAuthGrantTypeVisitor();
    private static final String CALLBACK_FIELD_NAME = "callbackValue";
    private static final String SDK_CALLBACK_FIELD_NAME = "sdkCallbackValue";
    private static final String CALLBACK_EXPRESSION = "#[payload.callback]";
    private static final String SDK_CALLBACK_EXPRESSION = "#[payload.sdkCallback]";
    private static final Map<String, String> CALLBACK_BINDING = new HashMap<String, String>(){
        {
            this.put(JavaConnectionProviderModelParserTestCase.CALLBACK_EXPRESSION, JavaConnectionProviderModelParserTestCase.CALLBACK_FIELD_NAME);
            this.put(JavaConnectionProviderModelParserTestCase.SDK_CALLBACK_EXPRESSION, JavaConnectionProviderModelParserTestCase.SDK_CALLBACK_FIELD_NAME);
        }
    };
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void noOAuthSupport() {
        Optional<OAuthModelProperty> oAuthModelProperty = this.parseOAuthModelPropertyFromConnectionProviderClass(BaseTestConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void authorizationCodeSupport() {
        Optional<OAuthModelProperty> oAuthModelProperty = this.parseOAuthModelPropertyFromConnectionProviderClass(AuthorizationCodeConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthModelProperty.get().getGrantTypes(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)), (Matcher)Matchers.instanceOf(AuthorizationCodeGrantType.class));
        ((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)).accept((OAuthGrantTypeVisitor)VALIDATION_O_AUTH_GRANT_TYPE_VISITOR);
    }

    @Test
    public void sdkAuthorizationCodeSupport() {
        Optional<OAuthModelProperty> oAuthModelProperty = this.parseOAuthModelPropertyFromConnectionProviderClass(SdkAuthorizationCodeConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthModelProperty.get().getGrantTypes(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)), (Matcher)Matchers.instanceOf(AuthorizationCodeGrantType.class));
        ((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)).accept((OAuthGrantTypeVisitor)VALIDATION_O_AUTH_GRANT_TYPE_VISITOR);
    }

    @Test
    public void bothAuthorizationCodeSupport() {
        this.expectedException.expect(IllegalParameterModelDefinitionException.class);
        this.parseOAuthModelPropertyFromConnectionProviderClass(BothAuthorizationCodeConnectionProvider.class);
    }

    @Test
    public void clientCredentialsSupport() {
        Optional<OAuthModelProperty> oAuthModelProperty = this.parseOAuthModelPropertyFromConnectionProviderClass(ClientCredentialsConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthModelProperty.get().getGrantTypes(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)), (Matcher)Matchers.instanceOf(ClientCredentialsGrantType.class));
        ((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)).accept((OAuthGrantTypeVisitor)VALIDATION_O_AUTH_GRANT_TYPE_VISITOR);
    }

    @Test
    public void sdkClientCredentialsSupport() {
        Optional<OAuthModelProperty> oAuthModelProperty = this.parseOAuthModelPropertyFromConnectionProviderClass(SdkClientCredentialsConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)oAuthModelProperty.get().getGrantTypes(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)), (Matcher)Matchers.instanceOf(ClientCredentialsGrantType.class));
        ((OAuthGrantType)oAuthModelProperty.get().getGrantTypes().get(0)).accept((OAuthGrantTypeVisitor)VALIDATION_O_AUTH_GRANT_TYPE_VISITOR);
    }

    @Test
    public void bothClientCredentialsSupport() {
        this.expectedException.expect(IllegalParameterModelDefinitionException.class);
        this.parseOAuthModelPropertyFromConnectionProviderClass(BothClientCredentialsConnectionProvider.class);
    }

    @Test
    public void oauthCallbackValues() {
        Optional<OAuthCallbackValuesModelProperty> oAuthCallbackValuesModelProperty = this.parseOAuthCallbackValuesModelPropertyFromConnectionProviderClass(OAuthCallbackValuesConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthCallbackValuesModelProperty.isPresent(), (Matcher)Matchers.is((Object)true));
        Map callbackValues = oAuthCallbackValuesModelProperty.get().getCallbackValues();
        MatcherAssert.assertThat((Object)callbackValues.size(), (Matcher)Matchers.is((Object)2));
        callbackValues.entrySet().stream().forEach(fieldStringEntry -> MatcherAssert.assertThat((Object)((Field)fieldStringEntry.getKey()).getName(), (Matcher)Matchers.is((Object)CALLBACK_BINDING.get(fieldStringEntry.getValue()))));
    }

    @Test
    public void noOauthCallbackValues() {
        Optional<OAuthCallbackValuesModelProperty> oAuthCallbackValuesModelProperty = this.parseOAuthCallbackValuesModelPropertyFromConnectionProviderClass(AuthorizationCodeConnectionProvider.class);
        MatcherAssert.assertThat((Object)oAuthCallbackValuesModelProperty.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void noManagementStrategyConnectionProvider() {
        this.mockConnectionProviderWithClass(AbstractTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.NONE));
    }

    @Test
    public void noManagementStrategySdkConnectionProvider() {
        this.mockConnectionProviderWithClass(SdkAbstractTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.NONE));
    }

    @Test
    public void isPoolingConnectionProvider() {
        this.mockConnectionProviderWithClass(PoolingTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.POOLING));
    }

    @Test
    public void isSdkPoolingConnectionProvider() {
        this.mockConnectionProviderWithClass(SdkPoolingTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.POOLING));
    }

    @Test
    public void isCachedConnectionProvider() {
        this.mockConnectionProviderWithClass(CachedTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.CACHED));
    }

    @Test
    public void isSdkCachedConnectionProvider() {
        this.mockConnectionProviderWithClass(SdkCachedTransactionalConnectionProvider.class);
        MatcherAssert.assertThat((Object)this.parser.getConnectionManagementType(), (Matcher)Matchers.is((Object)ConnectionManagementType.CACHED));
    }

    private Optional<OAuthModelProperty> parseOAuthModelPropertyFromConnectionProviderClass(Class<?> connectionProviderClass) {
        this.mockConnectionProviderWithClass(connectionProviderClass);
        return this.parser.getOAuthModelProperty();
    }

    private Optional<OAuthCallbackValuesModelProperty> parseOAuthCallbackValuesModelPropertyFromConnectionProviderClass(Class<?> connectionProviderClass) {
        this.mockConnectionProviderWithClass(connectionProviderClass);
        return this.parser.getAdditionalModelProperties().stream().filter(modelProperty -> modelProperty instanceof OAuthCallbackValuesModelProperty).map(OAuthCallbackValuesModelProperty.class::cast).findFirst();
    }

    protected void mockConnectionProviderWithClass(Class<?> connectionProviderClass) {
        this.connectionProviderElement = new ConnectionProviderTypeWrapper(connectionProviderClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        this.parser = new JavaConnectionProviderModelParser((JavaExtensionModelParser)Mockito.mock(JavaExtensionModelParser.class), (ExtensionElement)Mockito.mock(ExtensionElement.class), this.connectionProviderElement, MinMuleVersionTestUtils.ctxResolvingMinMuleVersion());
    }

    @Alias(value="Conn Alias")
    private class SdkAnnotatedConnectionProvider
    extends LegacyConnectionProvider {
        private SdkAnnotatedConnectionProvider() {
        }
    }

    private class ConnectionProviderExtendsSuperClass
    extends ParametrizedSuperClass
    implements org.mule.runtime.api.connection.ConnectionProvider<String> {
        private ConnectionProviderExtendsSuperClass() {
        }

        public String connect() throws ConnectionException {
            return null;
        }

        public void disconnect(String connection) {
        }

        public ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private class ParametrizedSuperClass {
        @Parameter
        String superClassParameter;

        private ParametrizedSuperClass() {
        }
    }

    @MinMuleVersion(value="4.4")
    private class ConnectionProviderWithLowerMMVAnnotation
    extends SdkConnectionProvider {
        private ConnectionProviderWithLowerMMVAnnotation() {
        }
    }

    @MinMuleVersion(value="4.5.0")
    private class ConnectionProviderWithHigherMMVAnnotation
    extends SdkConnectionProvider {
        private ConnectionProviderWithHigherMMVAnnotation() {
        }
    }

    private class ConnectionProviderExtendsSdkConnectionProvider
    extends SdkConnectionProvider {
        private ConnectionProviderExtendsSdkConnectionProvider() {
        }
    }

    private class ConnectionProviderWithSdkField
    extends LegacyConnectionProvider {
        Literal<String> literalField;

        private ConnectionProviderWithSdkField() {
        }
    }

    private class ConnectionProviderWithSdkParameter
    extends LegacyConnectionProvider {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        Literal<String> OAuthParameter;

        private ConnectionProviderWithSdkParameter() {
        }
    }

    private class ConnectionProviderWithParameterWithSdkAnnotation
    extends LegacyConnectionProvider {
        @OAuthParameter
        String OAuthParameter;

        private ConnectionProviderWithParameterWithSdkAnnotation() {
        }
    }

    private class SdkConnectionProvider
    implements ConnectionProvider<String> {
        private SdkConnectionProvider() {
        }

        public String connect() throws ConnectionException {
            return null;
        }

        public void disconnect(String connection) {
        }

        public org.mule.sdk.api.connectivity.ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private class LegacyConnectionProvider
    implements org.mule.runtime.api.connection.ConnectionProvider<String>,
    NoConnectivityTest {
        private LegacyConnectionProvider() {
        }

        public String connect() throws ConnectionException {
            return null;
        }

        public void disconnect(String connection) {
        }

        public ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private class SdkCachedTransactionalConnectionProvider
    extends SdkAbstractTransactionalConnectionProvider
    implements CachedConnectionProvider<SdkTestTransactionalConnection> {
        private SdkCachedTransactionalConnectionProvider() {
        }
    }

    private class SdkPoolingTransactionalConnectionProvider
    extends SdkAbstractTransactionalConnectionProvider
    implements PoolingConnectionProvider<SdkTestTransactionalConnection> {
        private SdkPoolingTransactionalConnectionProvider() {
        }
    }

    class SdkAbstractTransactionalConnectionProvider
    implements ConnectionProvider<SdkTestTransactionalConnection> {
        SdkAbstractTransactionalConnectionProvider() {
        }

        public SdkTestTransactionalConnection connect() throws ConnectionException {
            return null;
        }

        public void disconnect(SdkTestTransactionalConnection connection) {
        }

        public org.mule.sdk.api.connectivity.ConnectionValidationResult validate(SdkTestTransactionalConnection connection) {
            return null;
        }
    }

    protected static interface SdkTestTransactionalConnection
    extends TransactionalConnection {
    }

    private class CachedTransactionalConnectionProvider
    extends AbstractTransactionalConnectionProvider
    implements org.mule.runtime.api.connection.CachedConnectionProvider<TestTransactionalConnection> {
        private CachedTransactionalConnectionProvider() {
        }
    }

    private class PoolingTransactionalConnectionProvider
    extends AbstractTransactionalConnectionProvider
    implements org.mule.runtime.api.connection.PoolingConnectionProvider<TestTransactionalConnection> {
        private PoolingTransactionalConnectionProvider() {
        }
    }

    private class AbstractTransactionalConnectionProvider
    implements org.mule.runtime.api.connection.ConnectionProvider<TestTransactionalConnection> {
        private AbstractTransactionalConnectionProvider() {
        }

        public TestTransactionalConnection connect() throws ConnectionException {
            return null;
        }

        public void disconnect(TestTransactionalConnection connection) {
        }

        public ConnectionValidationResult validate(TestTransactionalConnection connection) {
            return null;
        }
    }

    static interface TestTransactionalConnection
    extends org.mule.runtime.extension.api.connectivity.TransactionalConnection {
    }

    @org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authorizationUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", refreshTokenExpr="refreshTokenExpr", defaultScopes="defaultScopes", credentialsPlacement=CredentialsPlacement.QUERY_PARAMS, includeRedirectUriInRefreshTokenRequest=false)
    private static class OAuthCallbackValuesConnectionProvider
    extends BaseTestConnectionProvider {
        @org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthCallbackValue(expression="#[payload.callback]")
        private String callbackValue;
        @OAuthCallbackValue(expression="#[payload.sdkCallback]")
        private String sdkCallbackValue;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        private String nonCallbackValue;

        private OAuthCallbackValuesConnectionProvider() {
        }
    }

    @org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials(tokenUrl="tokenUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", defaultScopes="defaultScopes", credentialsPlacement=CredentialsPlacement.QUERY_PARAMS)
    @ClientCredentials(tokenUrl="tokenUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", defaultScopes="defaultScopes", credentialsPlacement=org.mule.sdk.api.security.CredentialsPlacement.QUERY_PARAMS)
    private static class BothClientCredentialsConnectionProvider
    extends BaseTestConnectionProvider {
        private BothClientCredentialsConnectionProvider() {
        }
    }

    @ClientCredentials(tokenUrl="tokenUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", defaultScopes="defaultScopes", credentialsPlacement=org.mule.sdk.api.security.CredentialsPlacement.QUERY_PARAMS)
    private static class SdkClientCredentialsConnectionProvider
    extends BaseTestConnectionProvider {
        private SdkClientCredentialsConnectionProvider() {
        }
    }

    @org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials(tokenUrl="tokenUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", defaultScopes="defaultScopes", credentialsPlacement=CredentialsPlacement.QUERY_PARAMS)
    private static class ClientCredentialsConnectionProvider
    extends BaseTestConnectionProvider {
        private ClientCredentialsConnectionProvider() {
        }
    }

    @org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authorizationUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", refreshTokenExpr="refreshTokenExpr", defaultScopes="defaultScopes", credentialsPlacement=CredentialsPlacement.QUERY_PARAMS, includeRedirectUriInRefreshTokenRequest=false)
    @AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authorizationUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", refreshTokenExpr="refreshTokenExpr", defaultScopes="defaultScopes", credentialsPlacement=org.mule.sdk.api.security.CredentialsPlacement.QUERY_PARAMS, includeRedirectUriInRefreshTokenRequest=false)
    private static class BothAuthorizationCodeConnectionProvider
    extends BaseTestConnectionProvider {
        private BothAuthorizationCodeConnectionProvider() {
        }
    }

    @AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authorizationUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", refreshTokenExpr="refreshTokenExpr", defaultScopes="defaultScopes", credentialsPlacement=org.mule.sdk.api.security.CredentialsPlacement.QUERY_PARAMS, includeRedirectUriInRefreshTokenRequest=false)
    private static class SdkAuthorizationCodeConnectionProvider
    extends BaseTestConnectionProvider {
        private SdkAuthorizationCodeConnectionProvider() {
        }
    }

    @org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authorizationUrl", accessTokenExpr="accessTokenExpr", expirationExpr="expirationExpr", refreshTokenExpr="refreshTokenExpr", defaultScopes="defaultScopes", credentialsPlacement=CredentialsPlacement.QUERY_PARAMS, includeRedirectUriInRefreshTokenRequest=false)
    private static class AuthorizationCodeConnectionProvider
    extends BaseTestConnectionProvider {
        private AuthorizationCodeConnectionProvider() {
        }
    }

    private static class BaseTestConnectionProvider
    implements org.mule.runtime.api.connection.ConnectionProvider<String> {
        private BaseTestConnectionProvider() {
        }

        public String connect() throws ConnectionException {
            return "";
        }

        public void disconnect(String connection) {
        }

        public ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private static class ValidationOAuthGrantTypeVisitor
    implements OAuthGrantTypeVisitor {
        private ValidationOAuthGrantTypeVisitor() {
        }

        public void visit(AuthorizationCodeGrantType grantType) {
            MatcherAssert.assertThat((Object)grantType.getAccessTokenExpr(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.ACCESS_TOKEN_EXPR));
            MatcherAssert.assertThat((Object)grantType.getAccessTokenUrl(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.ACCESS_TOKEN_URL));
            MatcherAssert.assertThat((Object)grantType.getAuthorizationUrl(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.AUTHORIZATION_URL));
            MatcherAssert.assertThat((Object)grantType.getCredentialsPlacement(), (Matcher)Matchers.is((Object)CREDENTIALS_PLACEMENT));
            MatcherAssert.assertThat((Object)((String)grantType.getDefaultScope().get()), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.DEFAULT_SCOPES));
            MatcherAssert.assertThat((Object)grantType.getExpirationRegex(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.EXPIRATION_EXPR));
            MatcherAssert.assertThat((Object)grantType.getRefreshTokenExpr(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.REFRESH_TOKEN_EXPR));
            MatcherAssert.assertThat((Object)grantType.includeRedirectUriInRefreshTokenRequest(), (Matcher)Matchers.is((Object)false));
        }

        public void visit(ClientCredentialsGrantType grantType) {
            MatcherAssert.assertThat((Object)grantType.getAccessTokenExpr(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.ACCESS_TOKEN_EXPR));
            MatcherAssert.assertThat((Object)grantType.getCredentialsPlacement(), (Matcher)Matchers.is((Object)CREDENTIALS_PLACEMENT));
            MatcherAssert.assertThat((Object)((String)grantType.getDefaultScopes().get()), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.DEFAULT_SCOPES));
            MatcherAssert.assertThat((Object)grantType.getExpirationRegex(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.EXPIRATION_EXPR));
            MatcherAssert.assertThat((Object)grantType.getTokenUrl(), (Matcher)Matchers.is((Object)JavaConnectionProviderModelParserTestCase.TOKEN_URL));
        }

        public void visit(PlatformManagedOAuthGrantType grantType) {
        }
    }
}

