/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.type.catalog;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.module.extension.internal.type.catalog.DefaultArtifactTypeLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Types Catalog")
public class DefaultArtifactTypeLoaderTestCase
extends AbstractMuleTestCase {
    private static final String MOCK_EXTENSION_PREFIX = "mock";
    private static final String MOCK_TYPE_ALIAS = "MockType";
    private static final String MOCK_TYPE_ID = "MockTypeId";
    private static final String MOCK_EXTENSION_NAME = "Mock Extension";
    private static final String MOCK_TYPE_IDENTIFIER = "mock:MockTypeId";
    private static final String MOCK_TYPE_IDENTIFIER_FROM_ALIAS = "mock:MockType";
    private DefaultArtifactTypeLoader defaultArtifactTypeLoader;

    @Before
    public void setUp() throws InitialisationException {
        ExtensionModel mockExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        XmlDslModel dslModel = XmlDslModel.builder().setPrefix(MOCK_EXTENSION_PREFIX).build();
        Mockito.when((Object)mockExtensionModel.getXmlDslModel()).thenReturn((Object)dslModel);
        Mockito.when((Object)mockExtensionModel.getName()).thenReturn((Object)MOCK_EXTENSION_NAME);
        ObjectType mockType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(MOCK_TYPE_ID).with((TypeAnnotation)new TypeAliasAnnotation(MOCK_TYPE_ALIAS)).build();
        Mockito.when((Object)mockExtensionModel.getTypes()).thenReturn(Collections.singleton(mockType));
        ExpressionLanguageMetadataService mockMetadataService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        Mockito.when((Object)mockMetadataService.evaluateTypeExpression((String)ArgumentMatchers.eq((Object)MOCK_TYPE_ID), (Collection)ArgumentMatchers.any())).thenReturn((Object)mockType);
        this.defaultArtifactTypeLoader = new DefaultArtifactTypeLoader(Collections.singleton(mockExtensionModel), mockMetadataService);
        this.defaultArtifactTypeLoader.initialise();
    }

    @Test
    public void hasPrimitiveTypeString() {
        Assert.assertThat((Object)this.defaultArtifactTypeLoader.load("string").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void hasNotIncorrectType() {
        Assert.assertThat((Object)this.defaultArtifactTypeLoader.load("incorrect").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void hasVoidType() {
        Assert.assertThat((Object)this.defaultArtifactTypeLoader.load("void").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void objectTypeFromExtension() {
        Assert.assertThat((Object)this.defaultArtifactTypeLoader.load(MOCK_TYPE_IDENTIFIER).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void objectTypeFromExtensionUsingTypeID() {
        Assert.assertThat((Object)this.defaultArtifactTypeLoader.load(MOCK_TYPE_IDENTIFIER_FROM_ALIAS).isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

