/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.TestComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessorTestCase;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMessageProcessorClassLoadingTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessorTestCase.class);
    private ComponentMessageProcessor<ComponentModel> processor;
    private ExtensionModel extensionModel;
    private ComponentModel componentModel;
    private ResolverSet resolverSet;
    private MessageProcessorChain nestedChain;
    private ClassLoader applicationClassLoader;
    private ExtensionManager extensionManager;
    private PolicyManager policyManager;
    private ClassLoader contextClassLoader;

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
    }

    @Test
    @Issue(value="W-11625237")
    @Description(value="The ComponentMessageProcessor loads the application classLoader to start the processors and then goes back to the context classLoader.")
    public void componentMessageProcessorUsesTheApplicationClassLoaderToStartIfNeeded() throws MuleException {
        CoreEvent response = this.testEvent();
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("mock").build());
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{EnrichableModel.class}));
        Mockito.when((Object)this.componentModel.getModelProperty(CompletableComponentExecutorModelProperty.class)).thenReturn(Optional.of(new CompletableComponentExecutorModelProperty((cp, p) -> (ctx, callback) -> callback.complete((Object)response))));
        this.resolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        this.nestedChain = new DefaultMessageProcessorChainBuilder().build();
        this.applicationClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        this.extensionManager = (ExtensionManager)Mockito.mock(ExtensionManager.class);
        this.policyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.processor = new TestComponentMessageProcessor(this.extensionModel, this.componentModel, null, null, null, this.resolverSet, null, null, this.nestedChain, this.applicationClassLoader, this.extensionManager, this.policyManager, null, null, muleContext.getConfiguration().getShutdownTimeout()){

            protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
            }

            protected void startIfNeededNestedChain() throws MuleException {
                if (this.nestedChain != null) {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader currentClassLoader = currentThread.getContextClassLoader();
                    Assert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)ComponentMessageProcessorClassLoadingTestCase.this.contextClassLoader)));
                    ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)currentClassLoader, (ClassLoader)this.nestedChainClassLoader);
                    try {
                        Assert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)ComponentMessageProcessorClassLoadingTestCase.this.applicationClassLoader)));
                        LifecycleUtils.startIfNeeded((Object)this.nestedChain);
                    }
                    finally {
                        ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)this.nestedChainClassLoader, (ClassLoader)currentClassLoader);
                        Assert.assertThat((Object)currentClassLoader, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)ComponentMessageProcessorClassLoadingTestCase.this.contextClassLoader)));
                    }
                }
            }
        };
        this.processor.setAnnotations(ComponentMessageProcessorClassLoadingTestCase.getAppleFlowComponentLocationAnnotations());
        this.processor.setComponentLocator(this.componentLocator);
        this.processor.setCacheIdGeneratorFactory(Optional.of((MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class)));
        this.processor.setMuleConfiguration(muleContext.getConfiguration());
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        this.processor.doStart();
        Assert.assertThat((Object)this.contextClassLoader, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)this.applicationClassLoader)));
    }
}

