/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.validator.ParameterPluralNameModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ParameterPluralNameModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel validParameterModel;
    @Mock(lenient=true)
    private ParameterModel invalidParameterModel;
    private ParameterPluralNameModelValidator validator = new ParameterPluralNameModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"extensionModel");
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("ns").setNamespace("http://www.mulesoft.org/schema/mule/ns").setSchemaLocation("http://www.mulesoft.org/schema/mule/heisenberg/current/mule-ns.xsd").build());
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"dummyOperation");
        Mockito.when((Object)this.validParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.validParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.validParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.invalidParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToListWithoutPluralName() {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(List.class));
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"thing");
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    public void isValidNameIfDoesntSupportChildElement() {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(List.class));
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"thing");
        Mockito.when((Object)this.invalidParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).build());
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    public void isValidNameIfRequiresExpression() {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(List.class));
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"thing");
        Mockito.when((Object)this.invalidParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.REQUIRED);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

