/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.enricher.DsqlDynamicMetadataDeclarationEnricher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;

public class DsqlDynamicMetadataDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(MetadataExtension.class, MuleManifest.getProductVersion());
        new DsqlDynamicMetadataDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, ((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void outputTypeResolverInformationSetForDsql() throws Exception {
        OperationDeclaration query = (OperationDeclaration)EnricherTestUtils.getDeclaration(this.declaration.getOperations(), "doQuery");
        Optional info = query.getModelProperty(TypeResolversInformationModelProperty.class);
        MatcherAssert.assertThat((Object)info.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypeResolversInformationModelProperty)info.get()).getCategoryName(), (Matcher)CoreMatchers.is((Object)"QueryResolverCategory"));
        MatcherAssert.assertThat((Object)((ResolverInformation)((TypeResolversInformationModelProperty)info.get()).getOutputResolver().get()).getResolverName(), (Matcher)CoreMatchers.is((Object)"QUERY_OUTPUT_RESOLVER-ENTITY-NativeQueryResolver"));
    }
}

