/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.CustomOAuthParameters;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;

public abstract class OAuthConfig<T extends OAuthGrantType> {
    private final String ownerConfigName;
    private final Optional<OAuthObjectStoreConfig> storeConfig;
    private final CustomOAuthParameters customOAuthParameters;
    private final Map<Field, String> parameterExtractors;

    public OAuthConfig(String ownerConfigName, Optional<OAuthObjectStoreConfig> storeConfig, CustomOAuthParameters customOAuthParameters, Map<Field, String> parameterExtractors) {
        this.ownerConfigName = ownerConfigName;
        this.storeConfig = storeConfig;
        this.customOAuthParameters = customOAuthParameters;
        this.parameterExtractors = parameterExtractors;
    }

    public abstract T getGrantType();

    public String getOwnerConfigName() {
        return this.ownerConfigName;
    }

    public Optional<OAuthObjectStoreConfig> getStoreConfig() {
        return this.storeConfig;
    }

    public MultiMap<String, String> getCustomQueryParameters() {
        return this.customOAuthParameters.getQueryParams();
    }

    public Map<String, String> getCustomBodyParameters() {
        return this.customOAuthParameters.getBodyParams();
    }

    public MultiMap<String, String> getCustomHeaders() {
        return this.customOAuthParameters.getHeaders();
    }

    public Map<Field, String> getParameterExtractors() {
        return this.parameterExtractors;
    }
}

