/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentParameterizationUtils;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ComponentParameterizationUtilsTestCase {
    private static final String PARAMETER_NAME = "parameterName";
    private static final String COMPONENT_NAME = "mockModel";
    private static final String ANOTHER_PARAMETER_NAME = "anotherParameterName";
    private static final String PARAMETER_GROUP_NAME = "parameterName";
    private static final String ANOTHER_PARAMETER_GROUP_NAME = "anotherParameterName";
    private static final String PARAMETER_VALUE = "parameterValue";
    private static final String ANOTHER_PARAMETER_VALUE = "anotherParameterValue";
    @Mock(strictness=Mock.Strictness.LENIENT)
    private ParameterizedModel parameterizedModelMock;
    @Mock
    private ParameterGroupModel parameterGroupModelMock;
    @Mock
    private ParameterGroupModel anotherParameterGroupModelMock;
    @Mock
    private ParameterModel parameterModelMock;
    @Mock
    private ParameterModel anotherParameterModelMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.parameterModelMock.getName()).thenReturn((Object)"parameterName");
        Mockito.when((Object)this.anotherParameterModelMock.getName()).thenReturn((Object)"anotherParameterName");
        Mockito.when((Object)this.parameterGroupModelMock.getName()).thenReturn((Object)"parameterName");
        Mockito.when((Object)this.anotherParameterGroupModelMock.getName()).thenReturn((Object)"anotherParameterName");
        Mockito.when((Object)this.parameterizedModelMock.getName()).thenReturn((Object)COMPONENT_NAME);
        Mockito.when((Object)this.parameterizedModelMock.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModelMock, this.anotherParameterGroupModelMock));
        Mockito.when((Object)this.parameterGroupModelMock.getParameter("parameterName")).thenReturn(Optional.of(this.parameterModelMock));
        Mockito.when((Object)this.anotherParameterGroupModelMock.getParameter("anotherParameterName")).thenReturn(Optional.of(this.anotherParameterModelMock));
    }

    @Test
    public void parameterValueIsMappedCorrectlyToEachParameterGroup() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("parameterName", PARAMETER_VALUE);
        parameters.put("anotherParameterName", ANOTHER_PARAMETER_VALUE);
        ComponentParameterization componentParameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)this.parameterizedModelMock, parameters);
        MatcherAssert.assertThat((Object)componentParameterization.getParameter("parameterName", "parameterName"), (Matcher)CoreMatchers.is((Object)PARAMETER_VALUE));
        MatcherAssert.assertThat((Object)componentParameterization.getParameter("anotherParameterName", "anotherParameterName"), (Matcher)CoreMatchers.is((Object)ANOTHER_PARAMETER_VALUE));
    }

    @Test
    public void parameterizedModelWithDuplicatedParameterName() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(String.format("Parameter '%s' exists in more than one group for component '%s'", "parameterName", COMPONENT_NAME));
        Mockito.when((Object)this.anotherParameterGroupModelMock.getParameter("parameterName")).thenReturn(Optional.of(this.anotherParameterModelMock));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("parameterName", PARAMETER_VALUE);
        ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)this.parameterizedModelMock, parameters);
    }
}

