/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.enricher.ValueProvidersParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.values.extension.ValuesExtension;

public class ValueProvidersParameterDeclarationEnricherTestCase {
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(ValuesExtension.class, MuleManifest.getProductVersion());
        new ValueProvidersParameterDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifyValueProviderWithoutParameters() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("singleValuesEnabledParameter", "channels");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void verifyValueProviderWithRequiredParameter() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withRequiredParameter", "providedParameters");
        this.assertWithRequiredParameter(parameterDeclaration, "requiredValue");
    }

    @Test
    public void verifyValueProviderWithRequiredParameterWithAlias() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)MuleExtensionUtils.getNamedObject((List)this.declaration.getOperations(), (String)"singleValuesWithRequiredParameterWithAlias");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)MuleExtensionUtils.getNamedObject((List)operationDeclaration.getAllParameters(), (String)"channels");
        ParameterDeclaration aliasedParameterDeclaration = (ParameterDeclaration)MuleExtensionUtils.getNamedObject((List)operationDeclaration.getAllParameters(), (String)"superString");
        Optional modelProperty = aliasedParameterDeclaration.getModelProperty(DeclaringMemberModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DeclaringMemberModelProperty)modelProperty.get()).getDeclaringField(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((DeclaringMemberModelProperty)modelProperty.get()).getDeclaringField().getName(), (Matcher)CoreMatchers.is((Object)"requiredString"));
        this.assertWithRequiredParameter(parameterDeclaration, "superString");
    }

    @Test
    public void verifyValueProviderWithOptionalParameter() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withOptionalParameter", "providedParameters");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.contains(this.item("optionalValue", false)));
    }

    @Test
    public void verifyValueProviderWithRequiredAndOptionalParameters() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withRequiredAndOptionalParameters", "providedParameters");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.contains((Object[])new String[]{"requiredValue"}));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.item("requiredValue", true), this.item("optionalValue", false)}));
    }

    @Test
    public void verifyParametersOfValueProviderModel() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withRequiredParameter", "providedParameters");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        ActingParameterModel parameter = (ActingParameterModel)parameterDeclaration.getValueProviderModel().getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void verifyFieldValueProviderWithoutParametersForOperationParameterWithOneFieldValues() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("singleValuesEnabledParameterWithOneFieldValues", "body");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getFieldValueProviderModels(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(0)).getTargetSelector(), (Matcher)CoreMatchers.is((Object)"simple.path"));
        MatcherAssert.assertThat((Object)((FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(0)).getParameters(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void verifyFieldValueProviderWithoutParametersForOperationParameterWithMoreThanOneFieldValues() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("singleValuesEnabledParameterWithMoreThanOneFieldValues", "body");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getFieldValueProviderModels(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(0)).getTargetSelector(), (Matcher)CoreMatchers.is((Object)"simple.path"));
        MatcherAssert.assertThat((Object)((FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(1)).getTargetSelector(), (Matcher)CoreMatchers.is((Object)"another.simple.path"));
        MatcherAssert.assertThat((Object)((FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(0)).getParameters(), (Matcher)Matchers.hasSize((int)0));
    }

    private void assertWithRequiredParameter(ParameterDeclaration parameterDeclaration, String parameterName) {
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getActingParameters(), (Matcher)Matchers.contains((Object[])new String[]{parameterName}));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.contains(this.item(parameterName, true)));
    }

    @Test
    public void verifyExtractinExpressionOfParametersOfValueProviderModelWithoutBinding() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withRequiredParameter", "providedParameters");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        ActingParameterModel parameter = (ActingParameterModel)parameterDeclaration.getValueProviderModel().getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
    }

    @Test
    public void verifyExtractinExpressionOfParametersOfValueProviderModelWithBinding() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withBoundActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        ActingParameterModel parameter = (ActingParameterModel)parameterDeclaration.getValueProviderModel().getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"actingParameter"));
    }

    @Test
    public void verifyExtractionExpressionOfParametersOfValueProviderModelWithBindingToField() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withBoundActingParameterField", "parameterWithValues");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel().getParameters(), (Matcher)Matchers.hasSize((int)1));
        ActingParameterModel parameter = (ActingParameterModel)parameterDeclaration.getValueProviderModel().getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"actingParameter.field"));
    }

    @Test
    public void verifyParameterWithFieldValueProviderWithFieldActingParameters() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("tagContentAsActingForAttributeValue", "xmlBody");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getFieldValueProviderModels(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getFieldValueProviderModels(), (Matcher)Matchers.hasSize((int)1));
        FieldValueProviderModel fieldValueProviderModel = (FieldValueProviderModel)parameterDeclaration.getFieldValueProviderModels().get(0);
        MatcherAssert.assertThat((Object)fieldValueProviderModel.getTargetSelector(), (Matcher)CoreMatchers.is((Object)"nested.tag.@customAttribute"));
        MatcherAssert.assertThat((Object)fieldValueProviderModel.getParameters(), (Matcher)Matchers.hasSize((int)1));
        ActingParameterModel parameter = (ActingParameterModel)fieldValueProviderModel.getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"requiredValue"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"xmlBody.nested.someTag"));
    }

    @Test
    public void verifySinceMuleVersionModelPropertyAdded() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("withBoundActingParameterField", "parameterWithValues");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        ValueProviderModel valueProviderModel = parameterDeclaration.getValueProviderModel();
        MatcherAssert.assertThat((Object)valueProviderModel.getModelProperty(SinceMuleVersionModelProperty.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        SinceMuleVersionModelProperty sinceMuleVersionModelProperty = (SinceMuleVersionModelProperty)valueProviderModel.getModelProperty(SinceMuleVersionModelProperty.class).get();
        MatcherAssert.assertThat((Object)sinceMuleVersionModelProperty.getVersion(), (Matcher)CoreMatchers.is((Object)new MuleVersion("4.4.0")));
    }

    @Test
    public void verifySinceMuleVersionModelPropertyNotAdded() {
        ParameterDeclaration parameterDeclaration = this.getParameterByOperationAndName("singleValuesEnabledParameterWithRequiredParameters", "channels");
        MatcherAssert.assertThat((Object)parameterDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameterDeclaration.getValueProviderModel(), (Matcher)CoreMatchers.notNullValue());
        ValueProviderModel valueProviderModel = parameterDeclaration.getValueProviderModel();
        MatcherAssert.assertThat((Object)valueProviderModel.getModelProperty(SinceMuleVersionModelProperty.class).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void verifyPartOrderIsAddedUsingBothApis() {
        ParameterDeclaration continentParameterDeclaration = this.getParameterByOperationAndName("multiLevelValue", "continent");
        MatcherAssert.assertThat((Object)continentParameterDeclaration.getValueProviderModel().getPartOrder(), (Matcher)CoreMatchers.is((Object)1));
        ParameterDeclaration countryParameterDeclaration = this.getParameterByOperationAndName("multiLevelValue", "country");
        MatcherAssert.assertThat((Object)countryParameterDeclaration.getValueProviderModel().getPartOrder(), (Matcher)CoreMatchers.is((Object)2));
        ParameterDeclaration cityParameterDeclaration = this.getParameterByOperationAndName("multiLevelValue", "city");
        MatcherAssert.assertThat((Object)cityParameterDeclaration.getValueProviderModel().getPartOrder(), (Matcher)CoreMatchers.is((Object)3));
    }

    private ParameterDeclaration getParameterByOperationAndName(String operationName, String parameterName) {
        OperationDeclaration operationDeclaration = (OperationDeclaration)MuleExtensionUtils.getNamedObject((List)this.declaration.getOperations(), (String)operationName);
        return (ParameterDeclaration)MuleExtensionUtils.getNamedObject((List)operationDeclaration.getAllParameters(), (String)parameterName);
    }

    private Matcher<Object> item(String name, boolean required) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)CoreMatchers.is((Object)name)), (Matcher)Matchers.hasProperty((String)"required", (Matcher)CoreMatchers.is((Object)required)));
    }
}

