/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultExecutionContextTestCase
extends AbstractMuleTestCase {
    private static final String CONFIG_NAME = "config";
    private static final String PARAM_NAME = "param1";
    private static final String VALUE = "Do you want to build a snowman?";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ResolverSetResult resolverSetResult;
    @Mock
    private CoreEvent event;
    @Mock
    private MuleContext muleContext;
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private CursorProviderFactory<Object> cursorProviderFactory;
    @Mock
    private Component component;
    @Mock
    private StreamingManager streamingManager;
    @Mock
    private ConfigurationState configurationState;
    @Mock
    private RetryPolicyTemplate retryPolicyTemplate;
    private final Object configurationInstance = new Object();
    private ConfigurationInstance configuration;
    private DefaultExecutionContext<OperationModel> operationContext;

    @Before
    public void before() {
        this.configuration = new LifecycleAwareConfigurationInstance(CONFIG_NAME, this.configurationModel, this.configurationInstance, this.configurationState, Optional.empty());
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put(PARAM_NAME, VALUE);
        Mockito.when((Object)this.resolverSetResult.asMap()).thenReturn(parametersMap);
        this.operationContext = new DefaultExecutionContext(this.extensionModel, Optional.of(this.configuration), this.resolverSetResult.asMap(), (ComponentModel)this.operationModel, this.event, this.cursorProviderFactory, this.streamingManager, this.component, this.retryPolicyTemplate, ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), this.muleContext);
    }

    @Test
    public void getParameter() {
        Assert.assertThat((Object)this.operationContext.hasParameter(PARAM_NAME), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((String)this.operationContext.getParameter(PARAM_NAME)), (Matcher)CoreMatchers.is((Object)VALUE));
    }

    @Test(expected=NoSuchElementException.class)
    public void getNonExistentParameter() {
        Assert.assertThat((Object)this.operationContext.hasParameter("param1_"), (Matcher)CoreMatchers.is((Object)false));
        this.operationContext.getParameter("param1_");
    }

    @Test
    public void variables() {
        String key = "foo";
        String value = "bar";
        Assert.assertThat((Object)this.operationContext.getVariable("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.operationContext.setVariable("foo", (Object)"bar"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((String)this.operationContext.getVariable("foo")), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)this.operationContext.setVariable("foo", (Object)""), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)((String)this.operationContext.getVariable("foo")), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)((String)this.operationContext.removeVariable("foo")), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.operationContext.getVariable("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=NullPointerException.class)
    public void setNullKeyVariable() {
        this.operationContext.setVariable(null, (Object)"");
    }

    @Test(expected=NullPointerException.class)
    public void setNullValueVariable() {
        this.operationContext.setVariable("key", null);
    }

    @Test(expected=NullPointerException.class)
    public void removeNullValueVariable() {
        this.operationContext.removeVariable(null);
    }

    @Test
    public void getRetryPolicyTemplate() {
        Assert.assertThat((Object)((RetryPolicyTemplate)this.operationContext.getRetryPolicyTemplate().get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.retryPolicyTemplate)));
    }
}

