/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class InterceptorChainTestCase
extends AbstractMuleTestCase {
    @Mock
    private Interceptor<OperationModel> interceptor1;
    @Mock
    private Interceptor<OperationModel> interceptor2;
    @Mock
    private Interceptor<OperationModel> interceptor3;
    @Mock
    private ExecutionContext<OperationModel> ctx;
    @Mock
    private CompletableComponentExecutor.ExecutorCallback callback;
    private InterceptorChain chain;
    private InOrder inOrder;

    @Before
    public void before() {
        this.inOrder = Mockito.inOrder((Object[])new Object[]{this.interceptor1, this.interceptor2, this.interceptor3});
        this.chain = InterceptorChain.builder().addInterceptor(this.interceptor1).addInterceptor(this.interceptor2).addInterceptor(this.interceptor3).build();
        this.mockErrorIdentity(this.interceptor1, this.interceptor2, this.interceptor3);
    }

    @Test
    public void beforePhase() throws Throwable {
        Assert.assertThat((Object)this.chain.before(this.ctx, this.callback), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ((Interceptor)this.inOrder.verify(this.interceptor1)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor1, Mockito.never())).after((ExecutionContext)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Interceptor)this.inOrder.verify(this.interceptor2, Mockito.never())).after((ExecutionContext)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Interceptor)this.inOrder.verify(this.interceptor3, Mockito.never())).after((ExecutionContext)ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void beforeWithLastInterceptorFail() throws Throwable {
        Exception e = new Exception();
        RuntimeException wrapped = new RuntimeException(e);
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{e}).when(this.interceptor3)).before((ExecutionContext)ArgumentMatchers.any());
        Mockito.when((Object)this.interceptor2.onError(this.ctx, (Throwable)e)).thenReturn((Object)wrapped);
        Assert.assertThat((Object)this.chain.before(this.ctx, this.callback), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)wrapped)));
        ((Interceptor)this.inOrder.verify(this.interceptor1)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onError(this.ctx, (Throwable)wrapped);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.verify((Object)this.callback)).error((Throwable)wrapped);
    }

    @Test
    public void beforeWithLastInterceptorFailAndAfterFailsAsWell() throws Throwable {
        Exception e = new Exception();
        RuntimeException wrapped = new RuntimeException(e);
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{e}).when(this.interceptor3)).before((ExecutionContext)ArgumentMatchers.any());
        Mockito.when((Object)this.interceptor2.onError(this.ctx, (Throwable)e)).thenReturn((Object)wrapped);
        this.mockAfterFails(new RuntimeException(), this.interceptor1, this.interceptor2, this.interceptor3);
        Assert.assertThat((Object)this.chain.before(this.ctx, this.callback), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)wrapped)));
        ((Interceptor)this.inOrder.verify(this.interceptor1)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).before(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onError(this.ctx, (Throwable)wrapped);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.verify((Object)this.callback)).error((Throwable)wrapped);
    }

    @Test
    public void onSuccess() throws Throwable {
        Object result = new Object();
        this.chain.onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, result);
    }

    @Test
    public void onSuccessWithFailure() throws Throwable {
        Object result = new Object();
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.interceptor2)).onSuccess(this.ctx, result);
        this.chain.onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, result);
    }

    @Test
    public void onSuccessWithFailureAndAfterFailsAsWell() throws Throwable {
        Object result = new Object();
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.interceptor2)).onSuccess(this.ctx, result);
        this.mockAfterFails(new RuntimeException(), this.interceptor1, this.interceptor2, this.interceptor3);
        this.chain.onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onSuccess(this.ctx, result);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, result);
    }

    @Test
    public void onError() throws Throwable {
        Exception e = new Exception();
        this.chain.onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, null);
    }

    @Test
    public void onErrorWithFailure() throws Throwable {
        Exception e = new Exception();
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.interceptor2)).onError(this.ctx, (Throwable)new RuntimeException());
        this.chain.onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, null);
    }

    @Test
    public void onErrorWithFailureFailsAsWell() throws Throwable {
        Exception e = new Exception();
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.interceptor2)).onError(this.ctx, (Throwable)new RuntimeException());
        this.mockAfterFails(new RuntimeException(), this.interceptor1, this.interceptor2, this.interceptor3);
        this.chain.onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).onError(this.ctx, (Throwable)e);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, null);
    }

    @Test
    public void abort() {
        this.chain.abort(this.ctx);
        ((Interceptor)this.inOrder.verify(this.interceptor1)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor2)).after(this.ctx, null);
        ((Interceptor)this.inOrder.verify(this.interceptor3)).after(this.ctx, null);
    }

    @Test
    public void noInterceptors() {
        this.chain = InterceptorChain.builder().build();
        Object result = Mockito.mock(Object.class);
        Exception e = (Exception)Mockito.spy((Object)new Exception());
        Assert.assertThat((Object)this.chain.before(this.ctx, this.callback), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.chain.onSuccess(this.ctx, result);
        Assert.assertThat((Object)this.chain.onError(this.ctx, (Throwable)e), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.chain.abort(this.ctx);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ctx, this.callback});
    }

    private void mockErrorIdentity(Interceptor<OperationModel> ... interceptors) {
        for (Interceptor<OperationModel> interceptor : interceptors) {
            Mockito.when((Object)interceptor.onError((ExecutionContext)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(1));
        }
    }

    private void mockAfterFails(Exception exception, Interceptor<OperationModel> ... interceptors) {
        for (Interceptor<OperationModel> interceptor : interceptors) {
            ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when(interceptor)).after((ExecutionContext)ArgumentMatchers.any(), ArgumentMatchers.any());
        }
    }
}

