/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.PagedOperationModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PagedOperationModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    private ExtensionModelValidator validator = new PagedOperationModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.of(new PagedOperationModelProperty()));
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void connectedPagingProvider() {
        this.mockOperationModel("connectedPagingProvider");
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void notConnectedPagingProvider() {
        this.mockOperationModel("notConnectedPagingProvider");
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    private void mockOperationModel(String method) {
        Mockito.when((Object)this.operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(IntrospectionUtils.getApiMethods(PagedOperations.class).stream().filter(m -> m.getName().equals(method)).findFirst().map(pagedMethod -> new ExtensionOperationDescriptorModelProperty((OperationElement)new OperationWrapper(pagedMethod, ExtensionsTestUtils.TYPE_LOADER))));
    }

    private static class PagedOperations {
        private PagedOperations() {
        }

        public PagingProvider<Object, Object> connectedPagingProvider(@Connection Object connection) {
            return null;
        }

        public PagingProvider<Object, Object> notConnectedPagingProvider() {
            return null;
        }
    }
}

