/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.MDC;

@Issue(value="MULE-19097")
public class CompletableOperationExecutorFactoryTestCase
extends AbstractMuleTestCase {
    private CompletableComponentExecutor<ComponentModel> executor;
    private ExecutionContextAdapter<ComponentModel> executionContext;
    private CompletableComponentExecutor.ExecutorCallback callback;
    private Reference<CompletionCallback<Object, Object>> completionCallbackRef;
    private Reference<ClassLoader> onErrorClassLoaderRef;
    private Reference<ClassLoader> onCompleteClassLoaderRef;
    private Reference<Map<String, String>> onErrorMDC;
    private Reference<Map<String, String>> onCompleteMDC;

    @Before
    public void setup() {
        CompletableOperationExecutorFactory factory = new CompletableOperationExecutorFactory(String.class, String.class.getMethods()[0]);
        this.executor = factory.createExecutor((ComponentModel)Mockito.mock(OperationModel.class), Collections.emptyMap());
        this.executionContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class);
        this.callback = (CompletableComponentExecutor.ExecutorCallback)Mockito.mock(CompletableComponentExecutor.ExecutorCallback.class);
        this.completionCallbackRef = new Reference();
        Mockito.when((Object)this.executionContext.setVariable((String)ArgumentMatchers.eq((Object)"MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), ArgumentMatchers.any(CompletionCallback.class))).thenAnswer(invocation -> {
            this.completionCallbackRef.set(invocation.getArgument(1));
            return null;
        });
        this.onErrorClassLoaderRef = new Reference();
        this.onErrorMDC = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            this.onErrorClassLoaderRef.set((Object)Thread.currentThread().getContextClassLoader());
            this.onErrorMDC.set((Object)MDC.getCopyOfContextMap());
            return null;
        }).when((Object)this.callback)).error((Throwable)ArgumentMatchers.any());
        this.onCompleteClassLoaderRef = new Reference();
        this.onCompleteMDC = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            this.onCompleteClassLoaderRef.set((Object)Thread.currentThread().getContextClassLoader());
            this.onCompleteMDC.set((Object)MDC.getCopyOfContextMap());
            return null;
        }).when((Object)this.callback)).complete(ArgumentMatchers.any());
    }

    @Test
    public void preserveClassLoaderOnError() {
        ClassLoader executionClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)executionClassLoader, () -> this.executor.execute(this.executionContext, this.callback));
        ClassLoader anotherClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)anotherClassLoader, () -> ((CompletionCallback)this.completionCallbackRef.get()).error((Throwable)new NullPointerException()));
        Assert.assertThat((Object)this.onErrorClassLoaderRef.get(), (Matcher)CoreMatchers.is((Object)executionClassLoader));
    }

    @Test
    public void preserveClassLoaderOnComplete() {
        ClassLoader executionClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)executionClassLoader, () -> this.executor.execute(this.executionContext, this.callback));
        ClassLoader anotherClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)anotherClassLoader, () -> ((CompletionCallback)this.completionCallbackRef.get()).success(null));
        Assert.assertThat((Object)this.onCompleteClassLoaderRef.get(), (Matcher)CoreMatchers.is((Object)executionClassLoader));
    }

    @Test
    public void preserveMDCOnError() {
        Map<String, String> executionMap = Collections.singletonMap("on", "execution");
        this.withMDC(executionMap, () -> this.executor.execute(this.executionContext, this.callback));
        Map<String, String> anotherMap = Collections.singletonMap("on", "another");
        this.withMDC(anotherMap, () -> ((CompletionCallback)this.completionCallbackRef.get()).error((Throwable)new NullPointerException()));
        Assert.assertThat(((Map)this.onErrorMDC.get()).get("on"), (Matcher)CoreMatchers.is((Object)"execution"));
    }

    @Test
    public void preserveMDCOnCompletion() {
        Map<String, String> executionMap = Collections.singletonMap("on", "execution");
        this.withMDC(executionMap, () -> this.executor.execute(this.executionContext, this.callback));
        Map<String, String> anotherMap = Collections.singletonMap("on", "another");
        this.withMDC(anotherMap, () -> ((CompletionCallback)this.completionCallbackRef.get()).success(null));
        Assert.assertThat(((Map)this.onCompleteMDC.get()).get("on"), (Matcher)CoreMatchers.is((Object)"execution"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withMDC(Map<String, String> mdc, Runnable callback) {
        Map oldMDC = MDC.getCopyOfContextMap();
        MDC.setContextMap(mdc);
        try {
            callback.run();
        }
        finally {
            MDC.setContextMap((Map)oldMDC);
        }
    }
}

