/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.enricher.SampleDataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.test.data.sample.extension.SampleDataExtension;

public class SampleDataDeclarationEnricherTestCase {
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = new DefaultJavaModelLoaderDelegate(SampleDataExtension.class, MuleManifest.getProductVersion()).declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new SampleDataDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifySampleDataProviderWithoutParameters() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "parameterLess");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void verifySampleDataProviderWithRequiredParameter() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "connectionLess");
        this.assertWithRequiredParameter(operationDeclaration, new String[]{"payload", "attributes"});
    }

    @Test
    public void verifySampleDataProviderWithParameterWithAlias() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), "aliasedGroup");
        this.assertAliasedParameter(operationDeclaration, "aliasedPayload", "payload");
        this.assertAliasedParameter(operationDeclaration, "aliasedAttributes", "attributes");
        this.assertWithRequiredParameter(operationDeclaration, new String[]{"aliasedPayload", "aliasedAttributes"});
    }

    @Test
    public void verifyValueProviderWithOptionalParameter() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "optionalParameters");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.item("payload", false), this.item("attributes", false)}));
    }

    @Test
    public void verifyValueProviderWithRequiredAndOptionalParameters() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), "parameterGroup");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.item("groupParameter", true), this.item("optionalParameter", false)}));
    }

    @Test
    public void verifyParametersOfValueProviderModel() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "connectionLess");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(operationDeclaration.getSampleDataProviderModel().get(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        ActingParameterModel parameter = (ActingParameterModel)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"payload"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void verifyExtractionExpressionOfSampleDataProviderModelWithoutBinding() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "connectionLess");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(operationDeclaration.getSampleDataProviderModel().get(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        ActingParameterModel parameter = (ActingParameterModel)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"payload"));
        MatcherAssert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"payload"));
    }

    @Test
    public void verifyExtractionExpressionOfSampleDataProviderModelWithBinding() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "connectionLessWithTwoBoundActingParameterFromContentField");
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(operationDeclaration.getSampleDataProviderModel().get(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        ActingParameterModel parameter1 = (ActingParameterModel)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters().get(0);
        MatcherAssert.assertThat((Object)parameter1, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter1.getName(), (Matcher)CoreMatchers.is((Object)"payload"));
        MatcherAssert.assertThat((Object)parameter1.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter1.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"message.payload"));
        ActingParameterModel parameter2 = (ActingParameterModel)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters().get(1);
        MatcherAssert.assertThat((Object)parameter2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)parameter2.getName(), (Matcher)CoreMatchers.is((Object)"attributes"));
        MatcherAssert.assertThat((Object)parameter2.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameter2.getExtractionExpression(), (Matcher)CoreMatchers.is((Object)"message.attributes"));
    }

    private void assertWithRequiredParameter(OperationDeclaration operationDeclaration, String[] parametersName) {
        MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)operationDeclaration.getSampleDataProviderModel().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasSize((int)2));
        for (String parameterName : parametersName) {
            MatcherAssert.assertThat((Object)((SampleDataProviderModel)operationDeclaration.getSampleDataProviderModel().get()).getParameters(), (Matcher)Matchers.hasItem((Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"name", (Matcher)CoreMatchers.is((Object)parameterName))).and(Matchers.hasProperty((String)"required", (Matcher)CoreMatchers.is((Object)true)))));
        }
    }

    private void assertAliasedParameter(OperationDeclaration operationDeclaration, String alias, String name) {
        ParameterDeclaration aliasedParameterDeclaration = (ParameterDeclaration)EnricherTestUtils.getNamedObject(operationDeclaration.getAllParameters(), alias);
        Optional modelProperty = aliasedParameterDeclaration.getModelProperty(DeclaringMemberModelProperty.class);
        MatcherAssert.assertThat((Object)modelProperty.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DeclaringMemberModelProperty)modelProperty.get()).getDeclaringField(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((DeclaringMemberModelProperty)modelProperty.get()).getDeclaringField().getName(), (Matcher)CoreMatchers.is((Object)name));
    }

    private Matcher<Object> item(String name, boolean required) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)CoreMatchers.is((Object)name)), (Matcher)Matchers.hasProperty((String)"required", (Matcher)CoreMatchers.is((Object)required)));
    }

    private ParameterDeclaration getParameterByOperationAndName(String operationName, String parameterName) {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), operationName);
        return (ParameterDeclaration)EnricherTestUtils.getNamedObject(operationDeclaration.getAllParameters(), parameterName);
    }
}

