/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.ModelValidationUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationModelValidator
implements ExtensionModelValidator {
    public void validate(final ExtensionModel model, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel operationModel) {
                ConfigurationModelValidator.this.validateInjectedConfigType(owner, operationModel, problemsReporter);
                List overrides = ConfigurationModelValidator.this.getOverrideParameters((ParameterizedModel)operationModel);
                if (!overrides.isEmpty()) {
                    if (owner instanceof ConfigurationModel) {
                        List invalidOverrides = ConfigurationModelValidator.this.getInvalidOverrides((ConfigurationModel)owner, overrides);
                        if (!invalidOverrides.isEmpty()) {
                            ConfigurationModelValidator.this.reportNoMatchingParameterForOverride(((ConfigurationModel)owner).getName(), (ComponentModel)operationModel, invalidOverrides, problemsReporter);
                        }
                    } else if (!model.getConfigurationModels().isEmpty()) {
                        ConfigurationModelValidator.this.reportNoConfigurationForOverride((ComponentModel)operationModel, problemsReporter);
                    }
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel sourceModel) {
                List overrides = ConfigurationModelValidator.this.getOverrideParameters((ParameterizedModel)sourceModel);
                if (!overrides.isEmpty()) {
                    if (owner instanceof ConfigurationModel) {
                        List invalidOverrides = ConfigurationModelValidator.this.getInvalidOverrides((ConfigurationModel)owner, overrides);
                        if (!invalidOverrides.isEmpty()) {
                            ConfigurationModelValidator.this.reportNoMatchingParameterForOverride(((ConfigurationModel)owner).getName(), (ComponentModel)sourceModel, invalidOverrides, problemsReporter);
                        }
                    } else if (!model.getConfigurationModels().isEmpty()) {
                        ConfigurationModelValidator.this.reportNoConfigurationForOverride((ComponentModel)sourceModel, problemsReporter);
                    }
                }
            }

            protected void onConfiguration(ConfigurationModel model2) {
                ModelValidationUtils.validateConfigParametersNamesNotAllowed((ParameterizedModel)model2, problemsReporter, "Configuration");
                ModelValidationUtils.validateConfigOverrideParametersNotAllowed((ParameterizedModel)model2, problemsReporter, "Configuration");
            }
        }.walk(model);
    }

    private void reportNoMatchingParameterForOverride(String ownerName, ComponentModel model, List<String> parameters, ProblemsReporter reporter) {
        reporter.addError(new Problem((NamedObject)model, String.format("%s '%s' declares parameters %s as '%s' but associated Configuration '%s' does not declare parameters of the same name or alias.", StringUtils.capitalize((String)NameUtils.getComponentModelTypeName((ParameterizedModel)model)), model.getName(), parameters, ConfigOverride.class.getSimpleName(), ownerName)));
    }

    private void reportNoConfigurationForOverride(ComponentModel model, ProblemsReporter reporter) {
        reporter.addError(new Problem((NamedObject)model, String.format("%s '%s' declares parameters as '%s' but is not associated to a Configuration.", StringUtils.capitalize((String)NameUtils.getComponentModelTypeName((ParameterizedModel)model)), model.getName(), ConfigOverride.class.getSimpleName())));
    }

    private List<ParameterModel> getOverrideParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(ParameterModel::isOverrideFromConfig).collect(Collectors.toList());
    }

    private List<String> getInvalidOverrides(ConfigurationModel owner, List<ParameterModel> overrides) {
        return overrides.stream().filter(override -> owner.getAllParameterModels().stream().noneMatch(p -> p.getName().equals(override.getName()))).map(NamedObject::getName).collect(Collectors.toList());
    }

    private void validateInjectedConfigType(HasOperationModels owner, OperationModel operationModel, ProblemsReporter problemsReporter) {
        if (owner instanceof ConfigurationModel) {
            Class configType = MuleExtensionUtils.getConfigurationFactory((ConfigurationModel)owner).getObjectType();
            Optional<Class> operationConfigParameterType = operationModel.getModelProperty(ConfigTypeModelProperty.class).map(modelProperty -> modelProperty.getConfigType());
            if (operationConfigParameterType.isPresent() && !operationConfigParameterType.get().isAssignableFrom(configType)) {
                problemsReporter.addError(new Problem((NamedObject)operationModel, String.format("Operation '%s' requires a configuration of type '%s'. However, the operation is reachable from configuration '%s' of incompatible type '%s'.", operationModel.getName(), operationConfigParameterType.get().getName(), ((ConfigurationModel)owner).getName(), configType.getName())));
            }
        }
    }
}

