/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation.retry;

import java.util.Optional;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.operation.retry.RetryPolicyTemplateResolver;

public class ComponentRetryPolicyTemplateResolver
implements RetryPolicyTemplateResolver {
    private final RetryPolicyTemplate componentRetryPolicyTemplate;
    private final ConnectionManagerAdapter connectionManager;
    private final RetryPolicyTemplate fallbackRetryPolicyTemplate = new NoRetryPolicyTemplate();

    public ComponentRetryPolicyTemplateResolver(RetryPolicyTemplate retryPolicyTemplate, ConnectionManagerAdapter connectionManager) {
        this.componentRetryPolicyTemplate = retryPolicyTemplate;
        this.connectionManager = connectionManager;
    }

    @Override
    public RetryPolicyTemplate fetchRetryPolicyTemplate(Optional<ConfigurationInstance> configuration) {
        if (this.componentRetryPolicyTemplate == null) {
            return this.resolveRetryTemplateFromConnectionConfig(configuration);
        }
        return this.componentRetryPolicyTemplate;
    }

    private RetryPolicyTemplate resolveRetryTemplateFromConnectionConfig(Optional<ConfigurationInstance> configuration) {
        return configuration.map(config -> config.getConnectionProvider().orElse(null)).map(provider -> this.connectionManager.getRetryTemplateFor(provider)).orElse(this.fallbackRetryPolicyTemplate);
    }
}

