/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.FluxSink;

class InfiniteEmitter<T>
implements Consumer<FluxSink<T>> {
    private FluxSink<T> sink;
    private final Thread producerThread = new Thread(() -> {
        while (!this.stopRequested) {
            try {
                this.sink.next(itemSupplier.getItem());
            }
            catch (Exception e) {
                this.sink.error((Throwable)e);
            }
        }
    });
    private boolean stopRequested = false;

    public InfiniteEmitter(ItemSupplier<T> itemSupplier) {
    }

    @Override
    public void accept(FluxSink<T> sink) {
        this.sink = sink;
    }

    public void start() {
        Objects.requireNonNull(this.sink, "Attempted to start an unsubscribed source");
        this.producerThread.start();
    }

    public void stop() throws InterruptedException {
        if (!this.stopRequested) {
            this.stopRequested = true;
            this.producerThread.join();
            this.sink.complete();
        }
    }

    public static interface ItemSupplier<ItemType> {
        public ItemType getItem() throws Exception;
    }
}

