/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ExportedClassNamesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class JavaExportedTypesDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext context;
    @Mock
    private ExtensionDeclarer declarer;
    @Mock
    private ExtensionDeclaration declaration;
    @Mock
    private ExtensionTypeDescriptorModelProperty typeDescriptorModelProperty;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Type type;
    @Mock
    private AnnotationValueFetcher annotationValueFetcher;
    private JavaExportedTypesDeclarationEnricher enricher = new JavaExportedTypesDeclarationEnricher();

    @Before
    public void before() {
        Mockito.when((Object)this.context.getExtensionDeclarer()).thenReturn((Object)this.declarer);
        Mockito.when((Object)this.declarer.getDeclaration()).thenReturn((Object)this.declaration);
        Mockito.when((Object)this.declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(this.typeDescriptorModelProperty));
        Mockito.when((Object)this.typeDescriptorModelProperty.getType()).thenReturn((Object)this.type);
        Mockito.when((Object)this.type.getValueFromAnnotation(Export.class)).thenReturn(Optional.of(this.annotationValueFetcher));
        Mockito.when((Object)this.annotationValueFetcher.getClassArrayValue((Function)ArgumentMatchers.any())).thenReturn(Arrays.asList(this.type));
        Mockito.when((Object)this.type.getClassInformation().getClassname()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void enrichWithExportedClassNameModelProperty() {
        this.enricher.enrich(this.context);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExportedClassNamesModelProperty.class);
        ((ExtensionDeclarer)Mockito.verify((Object)this.declarer)).withModelProperty((ModelProperty)captor.capture());
        ExportedClassNamesModelProperty property = (ExportedClassNamesModelProperty)captor.getValue();
        Assert.assertThat((Object)property.getExportedClassNames(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(property.getExportedClassNames().iterator().next(), (Matcher)CoreMatchers.equalTo((Object)((Object)((Object)this)).getClass().getName()));
    }
}

