/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

public class BooleanParameterDeclarationEnricherTestCase {
    private ExtensionDeclaration declaration = null;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = new DefaultJavaModelLoaderDelegate(HeisenbergExtension.class, MuleManifest.getProductVersion()).declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new BooleanParameterDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifyConfigurationModelPropertyOnOperation() {
        ParameterDeclaration booleanDeclaration = (ParameterDeclaration)EnricherTestUtils.getNamedObject(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getAllParameters(), "lovesMinerals");
        MatcherAssert.assertThat((Object)booleanDeclaration.isRequired(), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)booleanDeclaration.getDefaultValue(), (Matcher)CoreMatchers.is((Object)String.valueOf(Boolean.FALSE)));
        booleanDeclaration = (ParameterDeclaration)EnricherTestUtils.getNamedObject(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getAllParameters(), "worksAtDEA");
        MatcherAssert.assertThat((Object)booleanDeclaration.isRequired(), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)booleanDeclaration.getDefaultValue(), (Matcher)CoreMatchers.is((Object)String.valueOf(Boolean.TRUE)));
    }
}

