/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.loader.java.type;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithName;
import org.mule.runtime.module.extension.api.loader.java.type.WithType;

@NoImplement
public interface PropertyElement
extends WithType,
WithName {
    public Accessibility getAccess();

    public static PropertyElementBuilder builder() {
        return new PropertyElementBuilder();
    }

    public static class PropertyElementBuilder {
        private Type type;
        private String name;
        private Accessibility accessibility;

        public PropertyElementBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public PropertyElementBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PropertyElementBuilder accessibility(Accessibility accessibility) {
            this.accessibility = accessibility;
            return this;
        }

        public PropertyElement build() {
            return new DefaultPropertyElement(this.type, this.name, this.accessibility);
        }
    }

    public static final class DefaultPropertyElement
    implements PropertyElement {
        private final Type type;
        private final String name;
        private final Accessibility accessibility;

        private DefaultPropertyElement(Type type, String name, Accessibility accessibility) {
            this.type = type;
            this.name = name;
            this.accessibility = accessibility;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Accessibility getAccess() {
            return this.accessibility;
        }
    }

    public static enum Accessibility {
        READ_ONLY,
        WRITE_ONLY,
        READ_WRITE;

    }
}

