/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.runtime.source.Source;

public final class SourceTypeWrapper<T extends org.mule.runtime.extension.api.runtime.source.Source>
extends TypeWrapper
implements SourceElement,
ParameterizableTypeElement {
    private final Class<T> aClass;
    private LazyValue<List<org.mule.runtime.module.extension.api.loader.java.type.Type>> sourceGenerics;

    public SourceTypeWrapper(Class<T> aClass, ClassTypeLoader typeLoader) {
        super(aClass, typeLoader);
        this.aClass = aClass;
        this.sourceGenerics = new LazyValue(() -> IntrospectionUtils.getSuperClassGenerics(aClass, org.mule.runtime.extension.api.runtime.source.Source.class.isAssignableFrom(aClass) ? org.mule.runtime.extension.api.runtime.source.Source.class : Source.class).stream().map(e -> new TypeWrapper((Type)e, typeLoader)).collect(Collectors.toList()));
    }

    @Override
    public List<org.mule.runtime.module.extension.api.loader.java.type.Type> getSuperClassGenerics() {
        return (List)this.sourceGenerics.get();
    }

    @Override
    public Optional<MethodElement> getOnResponseMethod() {
        return this.getMethodAnnotatedWith(OnSuccess.class);
    }

    @Override
    public Optional<MethodElement> getOnErrorMethod() {
        return this.getMethodAnnotatedWith(OnError.class);
    }

    @Override
    public Optional<MethodElement> getOnTerminateMethod() {
        return this.getMethodAnnotatedWith(OnTerminate.class);
    }

    @Override
    public Optional<MethodElement> getOnBackPressureMethod() {
        return this.getMethodAnnotatedWith(OnBackPressure.class);
    }

    private Optional<MethodElement> getMethodAnnotatedWith(Class<? extends Annotation> annotationType) {
        Class<T> searchClass = this.aClass;
        Collection<Method> methods = null;
        while (!Object.class.equals(searchClass) && (methods = IntrospectionUtils.getMethodsAnnotatedWith(searchClass, annotationType, false)).isEmpty()) {
            searchClass = searchClass.getSuperclass();
        }
        if (CollectionUtils.isEmpty(methods)) {
            return Optional.empty();
        }
        if (methods.size() > 1) {
            throw new IllegalSourceModelDefinitionException(String.format("Source declared in class '%s' declares more than one method annotated with '%s'", this.aClass.getName(), annotationType.getSimpleName()));
        }
        return Optional.of(new MethodWrapper(methods.iterator().next(), this.typeLoader));
    }
}

