/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.CustomStaticTypeDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CustomStaticTypeDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationDeclaration operationDeclaration;
    private Method schemaNotFoundMethod;
    private final CustomStaticTypeDeclarationEnricher enricher = new CustomStaticTypeDeclarationEnricher();

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.operationDeclaration));
        this.schemaNotFoundMethod = TestOperations.class.getMethod("schemaNotFound", new Class[0]);
        Mockito.when((Object)this.operationDeclaration.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.of(new ImplementingMethodModelProperty(this.schemaNotFoundMethod)));
    }

    @Test
    public void schemaNotFound() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Can't load schema [invalid.xsd]. It was not found in the resources.");
        this.enricher.enrich(this.extensionLoadingContext);
    }

    public class TestOperations {
        @OutputXmlType(schema="invalid.xsd", qname="name")
        public String schemaNotFound() {
            return "";
        }
    }
}

