/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Map;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.MDC;

public class PreservingThreadContextCompletionCallback<T, A>
implements CompletionCallback<T, A> {
    private final CompletionCallback<T, A> delegate;
    private final ClassLoader classLoader;
    private final Map<String, String> mdc;

    public PreservingThreadContextCompletionCallback(CompletionCallback<T, A> delegate) {
        this.delegate = delegate;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.mdc = MDC.getCopyOfContextMap();
    }

    public void success(Result<T, A> result) {
        try (ThreadContext ignored = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.success(result);
        }
    }

    public void error(Throwable e) {
        try (ThreadContext ignored = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.error(e);
        }
    }

    private static class ThreadContext
    implements AutoCloseable {
        private final Thread currentThread = Thread.currentThread();
        private final ClassLoader innerClassLoader;
        private final Map<String, String> innerMDC;
        private final ClassLoader outerClassLoader;
        private final Map<String, String> outerMDC;

        ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
            this.innerClassLoader = classLoader;
            this.innerMDC = mdc;
            this.outerClassLoader = this.currentThread.getContextClassLoader();
            this.outerMDC = MDC.getCopyOfContextMap();
            MDC.setContextMap(this.innerMDC);
            ThreadContext.setContextClassLoader(this.currentThread, this.outerClassLoader, this.innerClassLoader);
        }

        @Override
        public void close() {
            try {
                ThreadContext.setContextClassLoader(this.currentThread, this.innerClassLoader, this.outerClassLoader);
            }
            finally {
                MDC.setContextMap(this.outerMDC);
            }
        }

        private static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
            if (currentClassLoader != newClassLoader) {
                thread.setContextClassLoader(newClassLoader);
            }
        }
    }
}

